/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.plugin;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.image.Builder;
import org.aoju.bus.image.Format;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.galaxy.data.ElementDictionary;
import org.aoju.bus.image.galaxy.data.Sequence;
import org.aoju.bus.image.galaxy.data.VR;
import org.aoju.bus.image.metric.ApplicationEntity;
import org.aoju.bus.image.metric.Association;
import org.aoju.bus.image.metric.Connection;
import org.aoju.bus.image.metric.DimseRSPHandler;
import org.aoju.bus.image.metric.internal.pdu.AAssociateRQ;
import org.aoju.bus.image.metric.internal.pdu.Presentation;

public class MppsSCU {
    private static final ElementDictionary dict = ElementDictionary.getStandardElementDictionary();
    private static final String IN_PROGRESS = "IN PROGRESS";
    private static final String COMPLETED = "COMPLETED";
    private static final String DISCONTINUED = "DISCONTINUED";
    private static final int[] MPPS_TOP_LEVEL_ATTRS = new int[]{524293, 524384, 528434, 528672, 0x100010, 0x100020, 0x100021, 1048612, 0x100030, 0x100040, 0x200010, 3670032, 3670036, 3670112, 3670113, 3670114, 0x400244, 4194885, 4194899, 4194900, 4194912, 4194944};
    private static final int[] MPPS_TOP_LEVEL_TYPE_2_ATTRS = new int[]{528434, 528672, 0x100010, 0x100020, 0x100030, 0x100040, 0x200010, 0x400242, 4194883, 4194900, 4194901, 4194912};
    private static final int[] CREATE_MPPS_TOP_LEVEL_EMPTY_ATTRS = new int[]{4194896, 4194897, 4194945, 0x400340};
    private static final int[] FINAL_MPPS_TOP_LEVEL_ATTRS = new int[]{524293, 4194896, 4194897, 4194898, 4194945, 0x400340};
    private static final int[] SSA_ATTRS = new int[]{524368, 524369, 528656, 0x20000D, 3280992, 3280996, 0x400007, 0x400008, 0x400009, 4194342, 4194343, 0x401001, 4202518, 4202519};
    private static final int[] SSA_TYPE_2_ATTRS = new int[]{524368, 528656, 0x20000D, 3280992, 0x401001, 0x400007, 0x400008, 0x400009};
    private static final int[] PERF_SERIES_ATTRS = new int[]{528446, 528464, 528496, 1577008, 0x20000E};
    private static final int[] PERF_SERIES_TYPE_2_ATTRS = new int[]{524372, 528446, 528464, 528496, 0x400220};
    private static final String ppsStartDate;
    private static final String ppsStartTime;
    private final ApplicationEntity ae;
    private final Connection remote;
    private final AAssociateRQ rq = new AAssociateRQ();
    private final HashMap<String, MppsWithIUID> map = new HashMap();
    private final ArrayList<MppsWithIUID> created = new ArrayList();
    private Attributes attrs;
    private String uidSuffix;
    private boolean newPPSID;
    private int serialNo = (int)(System.currentTimeMillis() & Integer.MAX_VALUE);
    private String ppsuid;
    private String ppsid;
    private DecimalFormat ppsidFormat = new DecimalFormat("PPS-0000000000");
    private String protocolName = "UNKNOWN";
    private String archiveRequested;
    private String finalStatus = "COMPLETED";
    private Attributes discontinuationReason;
    private Properties codes;
    private Association as;
    private RSPHandlerFactory rspHandlerFactory = new RSPHandlerFactory(){

        @Override
        public DimseRSPHandler createDimseRSPHandlerForNCreate(final MppsWithIUID mppsWithUID) {
            return new DimseRSPHandler(MppsSCU.this.as.nextMessageID()){

                @Override
                public void onDimseRSP(Association as, Attributes cmd, Attributes data) {
                    switch (cmd.getInt(2304, -1)) {
                        case 0: 
                        case 263: 
                        case 278: {
                            mppsWithUID.iuid = cmd.getString(4096, mppsWithUID.iuid);
                            MppsSCU.this.addCreatedMpps(mppsWithUID);
                        }
                    }
                    super.onDimseRSP(as, cmd, data);
                }
            };
        }

        @Override
        public DimseRSPHandler createDimseRSPHandlerForNSet() {
            return new DimseRSPHandler(MppsSCU.this.as.nextMessageID());
        }
    };

    public MppsSCU(ApplicationEntity ae) {
        this.remote = new Connection();
        this.ae = ae;
    }

    public void setRspHandlerFactory(RSPHandlerFactory rspHandlerFactory) {
        this.rspHandlerFactory = rspHandlerFactory;
    }

    public Connection getRemoteConnection() {
        return this.remote;
    }

    public AAssociateRQ getAAssociateRQ() {
        return this.rq;
    }

    public void addCreatedMpps(MppsWithIUID mpps) {
        this.created.add(mpps);
    }

    public final void setUIDSuffix(String uidSuffix) {
        this.uidSuffix = uidSuffix;
    }

    public final void setPPSUID(String ppsuid) {
        this.ppsuid = ppsuid;
    }

    public final void setPPSID(String ppsid) {
        this.ppsid = ppsid;
    }

    public final void setPPSIDStart(int ppsidStart) {
        this.serialNo = ppsidStart;
    }

    public final void setPPSIDFormat(String ppsidFormat) {
        this.ppsidFormat = new DecimalFormat(ppsidFormat);
    }

    public final void setNewPPSID(boolean newPPSID) {
        this.newPPSID = newPPSID;
    }

    public final void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public final void setArchiveRequested(String archiveRequested) {
        this.archiveRequested = archiveRequested;
    }

    public final void setFinalStatus(String finalStatus) {
        this.finalStatus = finalStatus;
    }

    public final void setCodes(Properties codes) {
        this.codes = codes;
    }

    public void setAttributes(Attributes attrs) {
        this.attrs = attrs;
    }

    public final void setDiscontinuationReason(String codeValue) {
        if (null == this.codes) {
            throw new IllegalStateException("codec not initialized");
        }
        String codeMeaning = this.codes.getProperty(codeValue);
        if (null == codeMeaning) {
            throw new IllegalArgumentException("undefined internal value: " + codeValue);
        }
        int endDesignator = codeValue.indexOf(45);
        Attributes attrs = new Attributes(3);
        attrs.setString(524544, VR.SH, endDesignator >= 0 ? codeValue.substring(endDesignator + 1) : codeValue);
        attrs.setString(524546, VR.SH, endDesignator >= 0 ? codeValue.substring(0, endDesignator) : "DCM");
        attrs.setString(524548, VR.LO, codeMeaning);
        this.discontinuationReason = attrs;
    }

    public void setTransferSyntaxes(String[] tss) {
        this.rq.addPresentationContext(new Presentation(1, "1.2.840.10008.1.1", "1.2.840.10008.1.2"));
        this.rq.addPresentationContext(new Presentation(3, "1.2.840.10008.3.1.2.3.3", tss));
    }

    public void open() throws IOException, InterruptedException, InstrumentException, GeneralSecurityException {
        this.as = this.ae.connect(this.remote, this.rq);
    }

    public void close() throws IOException, InterruptedException {
        if (null != this.as) {
            this.as.waitForOutstandingRSP();
            this.as.release();
            this.as.waitForSocketClose();
        }
    }

    public void echo() throws IOException, InterruptedException {
        this.as.cecho().next();
    }

    public void createMpps() throws IOException, InterruptedException {
        for (MppsWithIUID mppsWithUID : this.map.values()) {
            this.createMpps(mppsWithUID);
        }
        this.as.waitForOutstandingRSP();
    }

    private void createMpps(MppsWithIUID mppsWithUID) throws IOException, InterruptedException {
        String iuid = mppsWithUID.iuid;
        Attributes mpps = mppsWithUID.mpps;
        mppsWithUID.mpps = new Attributes(mpps, FINAL_MPPS_TOP_LEVEL_ATTRS);
        mpps.setString(4194898, VR.CS, IN_PROGRESS);
        for (int tag : CREATE_MPPS_TOP_LEVEL_EMPTY_ATTRS) {
            mpps.setNull(tag, dict.vrOf(tag));
        }
        this.as.ncreate("1.2.840.10008.3.1.2.3.3", iuid, mpps, null, this.rspHandlerFactory.createDimseRSPHandlerForNCreate(mppsWithUID));
    }

    public void updateMpps() throws IOException, InterruptedException {
        for (MppsWithIUID mppsWithIUID : this.created) {
            this.setMpps(mppsWithIUID);
        }
    }

    private void setMpps(MppsWithIUID mppsWithIUID) throws IOException, InterruptedException {
        this.as.nset("1.2.840.10008.3.1.2.3.3", mppsWithIUID.iuid, mppsWithIUID.mpps, null, this.rspHandlerFactory.createDimseRSPHandlerForNSet());
    }

    public boolean addInstance(Attributes inst) {
        Builder.updateAttributes(inst, this.attrs, this.uidSuffix);
        String suid = inst.getString(0x20000D);
        if (null == suid) {
            return false;
        }
        MppsWithIUID mppsWithIUID = this.map.get(suid);
        if (null == mppsWithIUID) {
            mppsWithIUID = new MppsWithIUID(this.ppsuid(null), this.createMPPS(inst));
            this.map.put(suid, mppsWithIUID);
        }
        this.updateMPPS(mppsWithIUID.mpps, inst);
        return true;
    }

    public boolean addMPPS(String iuid, Attributes mpps) {
        this.map.put(iuid, new MppsWithIUID(this.ppsuid(iuid), mpps));
        return true;
    }

    private String ppsuid(String defval) {
        if (null == this.ppsuid) {
            return defval;
        }
        int size = this.map.size();
        switch (size) {
            case 0: {
                return this.ppsuid;
            }
            case 1: {
                this.map.values().iterator().next().iuid = this.map.values().iterator().next().iuid + ".1";
            }
        }
        return this.ppsuid + "." + (size + 1);
    }

    private String mkPPSID() {
        if (null != this.ppsid) {
            return this.ppsid;
        }
        String id = this.ppsidFormat.format(this.serialNo);
        if (++this.serialNo < 0) {
            this.serialNo = 0;
        }
        return id;
    }

    private Attributes createMPPS(Attributes inst) {
        Sequence raSeq;
        Attributes mpps = new Attributes();
        mpps.setString(4194881, VR.AE, this.ae.getAETitle());
        mpps.setString(0x400244, VR.DA, inst.getString(524320, ppsStartDate));
        mpps.setString(4194885, VR.TM, inst.getString(524336, ppsStartTime));
        for (int tag : MPPS_TOP_LEVEL_TYPE_2_ATTRS) {
            mpps.setNull(tag, dict.vrOf(tag));
        }
        mpps.addSelected(inst, MPPS_TOP_LEVEL_ATTRS);
        if (this.newPPSID || !mpps.containsValue(4194899)) {
            mpps.setString(4194899, VR.CS, this.mkPPSID());
        }
        mpps.setString(4194896, VR.DA, mpps.getString(0x400244));
        mpps.setString(4194897, VR.TM, mpps.getString(4194885));
        mpps.setString(4194898, VR.CS, this.finalStatus);
        Sequence dcrSeq = mpps.newSequence(4194945, 1);
        if (null != this.discontinuationReason) {
            dcrSeq.add(new Attributes(this.discontinuationReason));
        }
        if (null == (raSeq = inst.getSequence(4194933)) || raSeq.isEmpty()) {
            Sequence ssaSeq = mpps.newSequence(4194928, 1);
            Attributes ssa = new Attributes();
            ssaSeq.add(ssa);
            for (int tag : SSA_TYPE_2_ATTRS) {
                ssa.setNull(tag, dict.vrOf(tag));
            }
            ssa.addSelected(inst, SSA_ATTRS);
        } else {
            Sequence ssaSeq = mpps.newSequence(4194928, raSeq.size());
            for (Attributes ra : raSeq) {
                Attributes ssa = new Attributes();
                ssaSeq.add(ssa);
                for (int tag : SSA_TYPE_2_ATTRS) {
                    ssa.setNull(tag, dict.vrOf(tag));
                }
                ssa.addSelected(inst, SSA_ATTRS);
                ssa.addSelected(ra, SSA_ATTRS);
            }
        }
        mpps.newSequence(0x400340, 1);
        return mpps;
    }

    private void updateMPPS(Attributes mpps, Attributes inst) {
        String endTime = inst.getString(524338);
        if (null == endTime && null == (endTime = inst.getString(524339))) {
            endTime = inst.getString(524337);
        }
        if (null != endTime && endTime.compareTo(mpps.getString(4194897)) > 0) {
            mpps.setString(4194897, VR.TM, endTime);
        }
        Sequence prefSeriesSeq = mpps.getSequence(0x400340);
        Attributes prefSeries = this.getPerfSeries(prefSeriesSeq, inst);
        Sequence refSOPSeq = prefSeries.getSequence(528704);
        Attributes refSOP = new Attributes();
        refSOPSeq.add(refSOP);
        refSOP.setString(528720, VR.UI, inst.getString(524310));
        refSOP.setString(528725, VR.UI, inst.getString(524312));
    }

    private Attributes getPerfSeries(Sequence prefSeriesSeq, Attributes inst) {
        String suid = inst.getString(0x20000E);
        for (Attributes prefSeries : prefSeriesSeq) {
            if (!suid.equals(prefSeries.getString(0x20000E))) continue;
            return prefSeries;
        }
        Attributes prefSeries = new Attributes();
        prefSeriesSeq.add(prefSeries);
        for (int tag : PERF_SERIES_TYPE_2_ATTRS) {
            prefSeries.setNull(tag, dict.vrOf(tag));
        }
        prefSeries.setString(1577008, VR.LO, this.protocolName);
        prefSeries.addSelected(inst, PERF_SERIES_ATTRS);
        prefSeries.newSequence(528704, 10);
        if (null != this.archiveRequested) {
            prefSeries.setString(4236436, VR.CS, this.archiveRequested);
        }
        return prefSeries;
    }

    static {
        Date now = new Date();
        ppsStartDate = Format.formatDA(null, now);
        ppsStartTime = Format.formatTM(null, now);
    }

    public static interface RSPHandlerFactory {
        public DimseRSPHandler createDimseRSPHandlerForNCreate(MppsWithIUID var1);

        public DimseRSPHandler createDimseRSPHandlerForNSet();
    }

    public static final class MppsWithIUID {
        public String iuid;
        public Attributes mpps;

        MppsWithIUID(String iuid, Attributes mpps) {
            this.iuid = iuid;
            this.mpps = mpps;
        }
    }
}

