/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.logger.dialect.slf4j;

import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.aoju.bus.logger.Log;
import org.aoju.bus.logger.LogFactory;
import org.aoju.bus.logger.dialect.slf4j.Slf4jLog;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLoggerFactory;

public class Slf4jLogFactory
extends LogFactory {
    public Slf4jLogFactory() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Slf4jLogFactory(boolean failIfNOP) {
        super("Slf4j");
        this.checkLogExist(LoggerFactory.class);
        if (!failIfNOP) {
            return;
        }
        final StringBuilder buf = new StringBuilder();
        PrintStream err = System.err;
        System.setErr(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                buf.append((char)b);
            }
        }, true, StandardCharsets.US_ASCII));
        try {
            if (LoggerFactory.getILoggerFactory() instanceof NOPLoggerFactory) {
                throw new NoClassDefFoundError(buf.toString());
            }
            err.print(buf);
            err.flush();
        }
        finally {
            System.setErr(err);
        }
    }

    @Override
    public Log createLog(String name) {
        return new Slf4jLog(name);
    }

    @Override
    public Log createLog(Class<?> clazz) {
        return new Slf4jLog(clazz);
    }
}

