/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.additional.delete;

import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.SqlBuilder;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.aoju.bus.mapper.entity.EntityTable;
import org.aoju.bus.mapper.reflect.MetaObject;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class DeletePropertyProvider
extends MapperTemplate {
    public DeletePropertyProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public static String getColumnByProperty(Class<?> entityClass, String property) {
        EntityTable entityTable = EntityBuilder.getEntityTable(entityClass);
        EntityColumn entityColumn = entityTable.getPropertyMap().get(property);
        return entityColumn.getColumn();
    }

    public static boolean isNull(Object value, boolean safeDelete) {
        boolean isNull = false;
        if (safeDelete) {
            if (null == value) {
                throw new InstrumentException("\u5b89\u5168\u5220\u9664\u6a21\u5f0f\u4e0b\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u4e0d\u5e26\u67e5\u8be2\u6761\u4ef6\u7684 delete \u65b9\u6cd5");
            }
        } else if (null == value) {
            isNull = true;
        }
        return isNull;
    }

    public String deleteByProperty(MappedStatement ms) {
        String propertyHelper = DeletePropertyProvider.class.getName();
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        if (SqlBuilder.hasLogicDeleteColumn(entityClass)) {
            sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass)));
            sql.append("<set>");
            sql.append(SqlBuilder.logicDeleteColumnEqualsValue(entityClass, true));
            sql.append("</set>");
            MetaObject.forObject(ms).setValue("sqlCommandType", (Object)SqlCommandType.UPDATE);
        } else {
            sql.append(SqlBuilder.deleteFromTable(entityClass, this.tableName(entityClass)));
        }
        sql.append("<where>\n");
        sql.append("<if test=\"false==");
        sql.append("@");
        sql.append(propertyHelper);
        sql.append("@isNull(value, ");
        sql.append(this.getConfig().isSafeDelete());
        sql.append(")");
        sql.append("\">\n");
        String entityClassName = entityClass.getName();
        String ognl = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"), @org.aoju.bus.mapper.reflect.Reflector@fnToFieldName(fn))}";
        sql.append(ognl + " = #{value}\n");
        sql.append("</if>\n");
        sql.append("</where>");
        return sql.toString();
    }

    public String deleteInByProperty(MappedStatement ms) {
        String propertyHelper = DeletePropertyProvider.class.getName();
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        if (SqlBuilder.hasLogicDeleteColumn(entityClass)) {
            sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass)));
            sql.append("<set>");
            sql.append(SqlBuilder.logicDeleteColumnEqualsValue(entityClass, true));
            sql.append("</set>");
            MetaObject.forObject(ms).setValue("sqlCommandType", (Object)SqlCommandType.UPDATE);
        } else {
            sql.append(SqlBuilder.deleteFromTable(entityClass, this.tableName(entityClass)));
        }
        sql.append("<where>\n");
        String entityClassName = entityClass.getName();
        String sqlSegment = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"),@org.aoju.bus.mapper.reflect.Reflector@fnToFieldName(fn))} in<foreach open=\"(\" close=\")\" separator=\",\" collection=\"values\" item=\"obj\">\n#{obj}\n</foreach>\n";
        sql.append(sqlSegment);
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }

    public String deleteBetweenByProperty(MappedStatement ms) {
        String propertyHelper = DeletePropertyProvider.class.getName();
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        if (SqlBuilder.hasLogicDeleteColumn(entityClass)) {
            sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass)));
            sql.append("<set>");
            sql.append(SqlBuilder.logicDeleteColumnEqualsValue(entityClass, true));
            sql.append("</set>");
            MetaObject.forObject(ms).setValue("sqlCommandType", (Object)SqlCommandType.UPDATE);
        } else {
            sql.append(SqlBuilder.deleteFromTable(entityClass, this.tableName(entityClass)));
        }
        sql.append("<where>\n");
        String entityClassName = entityClass.getName();
        String sqlSegment = "${@" + propertyHelper + "@getColumnByProperty(@java.lang.Class@forName(\"" + entityClassName + "\"),@org.aoju.bus.mapper.reflect.Reflector@fnToFieldName(fn))} between #{begin} and #{end}";
        sql.append(sqlSegment);
        sql.append(SqlBuilder.whereLogicDelete(entityClass, false));
        sql.append("</where>");
        return sql.toString();
    }
}

