/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.jdcloud;

import java.util.HashMap;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.jdcloud.JdcloudProperty;

public class JdcloudSmsProvider
extends AbstractProvider<JdcloudProperty, Context> {
    public JdcloudSmsProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(JdcloudProperty entity) {
        HashMap<String, Object> bodys = new HashMap<String, Object>();
        bodys.put("regionId", entity.getEndpoint());
        bodys.put("templateId", entity.getTemplate());
        bodys.put("params", StringKit.split((CharSequence)entity.getParams(), ","));
        bodys.put("phoneList", entity.getReceive());
        bodys.put("signId", entity.getSignature());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String response = Httpx.post(entity.getUrl(), bodys, headers);
        int status = (Integer)JsonKit.getValue(response, "statusCode");
        String errcode = status == 200 ? Builder.ErrorCode.SUCCESS.getCode() : Builder.ErrorCode.FAILURE.getCode();
        String errmsg = status == 200 ? Builder.ErrorCode.SUCCESS.getMsg() : Builder.ErrorCode.FAILURE.getMsg();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }
}

