/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.bridge;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.bridge.LocalOfficeContextAware;
import org.aoju.bus.office.magic.Lo;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.metric.OfficeConnectEvent;
import org.aoju.bus.office.metric.OfficeConnectEventListener;

public class LocalOfficeBridgeFactory
implements LocalOfficeContextAware,
XEventListener {
    private static AtomicInteger bridgeIndex = new AtomicInteger();
    private final UnoUrl unoUrl;
    private final List<OfficeConnectEventListener> connectionEventListeners;
    private final AtomicBoolean connected = new AtomicBoolean();
    private Object desktopService;
    private XComponent bridgeComponent;
    private XComponentContext componentContext;
    private XComponentLoader componentLoader;

    public LocalOfficeBridgeFactory(UnoUrl unoUrl) {
        this.unoUrl = unoUrl;
        this.connectionEventListeners = new ArrayList<OfficeConnectEventListener>();
    }

    public void addConnectionEventListener(OfficeConnectEventListener connectionEventListener) {
        this.connectionEventListeners.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws InstrumentException {
        LocalOfficeBridgeFactory localOfficeBridgeFactory = this;
        synchronized (localOfficeBridgeFactory) {
            String connectPart = this.unoUrl.getConnectionAndParametersAsString();
            Logger.debug("Connecting with connectString '{}'", connectPart);
            try {
                XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
                XMultiComponentFactory localServiceManager = localContext.getServiceManager();
                XConnector connector = Lo.qi(XConnector.class, localServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", localContext));
                XConnection connection = connector.connect(connectPart);
                XBridgeFactory bridgeFactory = Lo.qi(XBridgeFactory.class, localServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", localContext));
                String bridgeName = "converter_" + bridgeIndex.getAndIncrement();
                XBridge bridge = bridgeFactory.createBridge(bridgeName, this.unoUrl.getProtocolAndParametersAsString(), connection, null);
                this.bridgeComponent = Lo.qi(XComponent.class, bridge);
                this.bridgeComponent.addEventListener((XEventListener)this);
                String rootOid = this.unoUrl.getRootOid();
                Object bridgeInstance = bridge.getInstance(rootOid);
                if (ObjectKit.isEmpty(bridgeInstance)) {
                    throw new InstrumentException("Server didn't provide an instance for '" + rootOid + "'", connectPart);
                }
                XMultiComponentFactory officeMultiComponentFactory = Lo.qi(XMultiComponentFactory.class, bridgeInstance);
                XPropertySet properties = Lo.qi(XPropertySet.class, officeMultiComponentFactory);
                this.componentContext = Lo.qi(XComponentContext.class, properties.getPropertyValue("DefaultContext"));
                this.desktopService = officeMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.componentContext);
                this.componentLoader = Lo.qi(XComponentLoader.class, this.desktopService);
                if (ObjectKit.isEmpty(this.componentLoader)) {
                    throw new InstrumentException("Could not create a desktop service", connectPart);
                }
                this.connected.set(true);
                Logger.info("Connected: '{}'", connectPart);
                OfficeConnectEvent connectionEvent = new OfficeConnectEvent(this);
                this.connectionEventListeners.stream().forEach(listener -> listener.connected(connectionEvent));
            }
            catch (InstrumentException connectionEx) {
                throw connectionEx;
            }
            catch (Exception ex) {
                throw new InstrumentException(String.format("Connection failed: '%s'; %s", connectPart, ex.getMessage()), connectPart, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        LocalOfficeBridgeFactory localOfficeBridgeFactory = this;
        synchronized (localOfficeBridgeFactory) {
            Logger.debug("Disconnecting from '{}'", this.unoUrl.getConnectionAndParametersAsString());
            this.bridgeComponent.dispose();
        }
    }

    public void disposing(EventObject eventObject) {
        if (this.connected.get()) {
            this.connected.set(false);
            this.componentContext = null;
            this.componentLoader = null;
            this.desktopService = null;
            this.bridgeComponent = null;
            Logger.info("Disconnected: '{}'", this.unoUrl.getConnectionAndParametersAsString());
            OfficeConnectEvent connectionEvent = new OfficeConnectEvent(this);
            this.connectionEventListeners.stream().forEach(listener -> listener.disconnected(connectionEvent));
        }
    }

    @Override
    public XComponentContext getComponentContext() {
        return this.componentContext;
    }

    @Override
    public XComponentLoader getComponentLoader() {
        return this.componentLoader;
    }

    @Override
    public XDesktop getDesktop() {
        return Lo.qi(XDesktop.class, this.desktopService);
    }

    public boolean isConnected() {
        return this.connected.get();
    }
}

