/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.metric;

import com.sun.star.lang.DisposedException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.thread.NamedThreadFactory;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.office.bridge.LocalOfficeBridgeFactory;
import org.aoju.bus.office.magic.UnoUrl;
import org.aoju.bus.office.metric.ConnectRetryable;
import org.aoju.bus.office.metric.OfficeProcess;
import org.aoju.bus.office.metric.OfficeProcessManagerBuilder;

public class OfficeProcessManager {
    private final OfficeProcess process;
    private final LocalOfficeBridgeFactory localOffice;
    private final ExecutorService executor;
    private final OfficeProcessManagerBuilder config;

    public OfficeProcessManager(UnoUrl unoUrl, OfficeProcessManagerBuilder config) {
        this.config = config;
        this.process = new OfficeProcess(unoUrl, config);
        this.localOffice = new LocalOfficeBridgeFactory(unoUrl);
        this.executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("OfficeProcessThread"));
    }

    private void doEnsureProcessExited(boolean deleteInstanceProfileDir) throws InstrumentException {
        try {
            int exitCode = this.process.getExitCode(this.config.getProcessRetryInterval(), this.config.getProcessTimeout());
            Logger.info("process exited with code {}", exitCode);
        }
        catch (InstrumentException retryTimeoutEx) {
            Logger.debug("doEnsureProcessExited times out", retryTimeoutEx);
            this.doTerminateProcess();
        }
        finally {
            if (deleteInstanceProfileDir) {
                this.process.deleteInstanceProfileDir();
            }
        }
    }

    private void doStartProcessAndConnect(boolean restart) throws InstrumentException {
        this.process.start(restart);
        try {
            new ConnectRetryable(this.process, this.localOffice).execute(this.config.getProcessRetryInterval(), this.config.getProcessTimeout());
        }
        catch (Exception ex) {
            if (ex instanceof InstrumentException) {
                throw (InstrumentException)ex;
            }
            throw new InstrumentException("Could not establish connection", ex);
        }
    }

    private void doStopProcess(boolean deleteInstanceProfileDir) throws InstrumentException {
        try {
            boolean terminated = this.localOffice.getDesktop().terminate();
            Logger.debug("The Office Process {}", terminated ? "has been terminated" : "is still running. Someone else prevents termination, e.g. the quickstarter");
        }
        catch (DisposedException disposedEx) {
            Logger.debug("Expected DisposedException catched and ignored in doStopProcess", new Object[]{disposedEx});
        }
        catch (Exception ex) {
            Logger.debug("Exception catched in doStopProcess", ex);
            this.doTerminateProcess();
        }
        finally {
            this.doEnsureProcessExited(deleteInstanceProfileDir);
        }
    }

    private void doTerminateProcess() throws InstrumentException {
        try {
            int exitCode = this.process.forciblyTerminate(this.config.getProcessRetryInterval(), this.config.getProcessTimeout());
            Logger.info("process forcibly terminated with code {}", exitCode);
        }
        catch (Exception ex) {
            throw new InstrumentException("Could not terminate process", ex);
        }
    }

    LocalOfficeBridgeFactory getLocalOffice() {
        return this.localOffice;
    }

    public void restartAndWait() throws InstrumentException {
        this.submitAndWait("Restart", () -> {
            this.doStopProcess(false);
            this.doStartProcessAndConnect(true);
            return null;
        });
    }

    public void restartDueToLostConnection() {
        Logger.info("Executing task 'Restart After Lost Connection'...", new Object[0]);
        this.executor.execute(() -> {
            try {
                this.doEnsureProcessExited(true);
                this.doStartProcessAndConnect(false);
            }
            catch (InstrumentException officeEx) {
                Logger.error("Could not restart process after connection lost.", officeEx);
            }
        });
    }

    public void restartDueToTaskTimeout() {
        Logger.info("Executing task 'Restart After Timeout'...", new Object[0]);
        this.executor.execute(() -> {
            try {
                this.doTerminateProcess();
            }
            catch (InstrumentException officeException) {
                Logger.error("Could not terminate process after task timeout.", officeException);
            }
        });
    }

    public void startAndWait() throws InstrumentException {
        this.submitAndWait("Start", () -> {
            this.doStartProcessAndConnect(false);
            return null;
        });
    }

    public void stopAndWait() throws InstrumentException {
        this.submitAndWait("Stop", () -> {
            this.doStopProcess(true);
            return null;
        });
    }

    private void submitAndWait(String taskName, Callable<Void> task) throws InstrumentException {
        Logger.info("Submitting task '{}' and waiting...", taskName);
        Future<Void> future = this.executor.submit(task);
        try {
            future.get();
            Logger.debug("Task '{}' executed successfully", taskName);
        }
        catch (ExecutionException executionEx) {
            Logger.debug("ExecutionException catched in submitAndWait", executionEx);
            if (executionEx.getCause() instanceof InstrumentException) {
                throw (InstrumentException)executionEx.getCause();
            }
            throw new InstrumentException("Failed to execute task '" + taskName + "'", executionEx.getCause());
        }
        catch (InterruptedException interruptedEx) {
            Thread.currentThread().interrupt();
        }
    }
}

