/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.office.support.excel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public class ExcelPicKit {
    public static Map<String, PictureData> getPicMap(Workbook workbook, int sheetIndex) {
        Assert.notNull(workbook, "Workbook must be not null !", new Object[0]);
        if (sheetIndex < 0) {
            sheetIndex = 0;
        }
        if (workbook instanceof HSSFWorkbook) {
            return ExcelPicKit.getPicMapXls((HSSFWorkbook)workbook, sheetIndex);
        }
        if (workbook instanceof XSSFWorkbook) {
            return ExcelPicKit.getPicMapXlsx((XSSFWorkbook)workbook, sheetIndex);
        }
        throw new IllegalArgumentException(StringKit.format((CharSequence)"Workbook type [{}] is not supported!", workbook.getClass()));
    }

    private static Map<String, PictureData> getPicMapXls(HSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> picMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (CollKit.isNotEmpty(pictures)) {
            HSSFSheet sheet = workbook.getSheetAt(sheetIndex);
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                if (!(shape instanceof HSSFPicture)) continue;
                int pictureIndex = ((HSSFPicture)shape).getPictureIndex() - 1;
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                picMap.put(StringKit.format((CharSequence)"{}_{}", anchor.getRow1(), anchor.getCol1()), (PictureData)pictures.get(pictureIndex));
            }
        }
        return picMap;
    }

    private static Map<String, PictureData> getPicMapXlsx(XSSFWorkbook workbook, int sheetIndex) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        XSSFSheet sheet = workbook.getSheetAt(sheetIndex);
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                if (!(shape instanceof XSSFPicture)) continue;
                XSSFPicture pic = (XSSFPicture)shape;
                CTMarker ctMarker = pic.getPreferredSize().getFrom();
                sheetIndexPicMap.put(StringKit.format((CharSequence)"{}_{}", ctMarker.getRow(), ctMarker.getCol()), (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }
}

