/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.io.resource.ClassPathResource;
import org.aoju.bus.core.key.ID;
import org.aoju.bus.core.key.Snowflake;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.XmlKit;
import org.aoju.bus.pay.Secure;

public class Builder {
    public static String hmacSha256(String data, String key) {
        return org.aoju.bus.crypto.Builder.hmac(Algorithm.HMACSHA256, key).digestHex(data);
    }

    public static String sha1(File dataFile) {
        return org.aoju.bus.crypto.Builder.sha1Hex(dataFile);
    }

    public static String sha1(InputStream data) {
        return org.aoju.bus.crypto.Builder.sha1Hex(data);
    }

    public static String sha1(String data) {
        return org.aoju.bus.crypto.Builder.sha1Hex(data);
    }

    public static String md5(String data) {
        return org.aoju.bus.crypto.Builder.md5Hex(data);
    }

    public static String decryptData(String base64Data, String key) {
        return org.aoju.bus.crypto.Builder.aes(Builder.md5(key).toLowerCase().getBytes()).decryptStr(base64Data);
    }

    public static String encryptData(String data, String key) {
        return org.aoju.bus.crypto.Builder.aes(Builder.md5(key).toLowerCase().getBytes()).encryptBase64(data.getBytes());
    }

    public static String generateStr() {
        return ID.fastSimpleUUID();
    }

    public static Snowflake getSnowflake(long workerId, long dataCenterId) {
        return ID.getSnowflake(workerId, dataCenterId);
    }

    public static String createLinkString(Map<String, String> params) {
        return Builder.createLinkString(params, false);
    }

    public static String createLinkString(Map<String, String> params, boolean encode) {
        return Builder.createLinkString(params, "&", encode);
    }

    public static String createLinkString(Map<String, String> params, String connStr, boolean encode) {
        return Builder.createLinkString(params, connStr, encode, false);
    }

    public static String createLinkString(Map<String, String> params, String connStr, boolean encode, boolean quotes) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                if (quotes) {
                    content.append(key).append("=").append('\"').append(encode ? Builder.urlEncode(value) : value).append('\"');
                    continue;
                }
                content.append(key).append("=").append(encode ? Builder.urlEncode(value) : value);
                continue;
            }
            if (quotes) {
                content.append(key).append("=").append('\"').append(encode ? Builder.urlEncode(value) : value).append('\"').append(connStr);
                continue;
            }
            content.append(key).append("=").append(encode ? Builder.urlEncode(value) : value).append(connStr);
        }
        return content.toString();
    }

    public static String urlEncode(String src) {
        return URLEncoder.encode(src, StandardCharsets.UTF_8).replace("+", "%20");
    }

    public static StringBuffer forEachMap(Map<String, String> params, String prefix, String suffix) {
        StringBuffer xml = new StringBuffer();
        if (StringKit.isNotEmpty(prefix)) {
            xml.append(prefix);
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringKit.isEmpty(value)) continue;
            xml.append("<").append(key).append(">");
            xml.append(entry.getValue());
            xml.append("</").append(key).append(">");
        }
        if (StringKit.isNotEmpty(suffix)) {
            xml.append(suffix);
        }
        return xml;
    }

    public static String toXml(Map<String, String> params) {
        StringBuffer xml = Builder.forEachMap(params, "<xml>", "</xml>");
        return xml.toString();
    }

    public static Map<String, Object> xmlToMap(String xmlStr) {
        return XmlKit.xmlToMap(xmlStr);
    }

    public static String buildSignMessage(String method, String url, long timestamp, String nonceStr, String body) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(method);
        arrayList.add(url);
        arrayList.add(String.valueOf(timestamp));
        arrayList.add(nonceStr);
        arrayList.add(body);
        return Builder.buildSignMessage(arrayList);
    }

    public static String buildSignMessage(String timestamp, String nonceStr, String body) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(timestamp);
        arrayList.add(nonceStr);
        arrayList.add(body);
        return Builder.buildSignMessage(arrayList);
    }

    public static String buildSignMessage(List<String> signMessage) {
        if (signMessage == null || signMessage.size() <= 0) {
            return null;
        }
        StringBuilder sbf = new StringBuilder();
        for (String str : signMessage) {
            sbf.append(str).append("\n");
        }
        return sbf.toString();
    }

    public static String createSign(ArrayList<String> signMessage, String keyPath) throws Exception {
        return Builder.createSign(Builder.buildSignMessage(signMessage), keyPath);
    }

    public static String createSign(ArrayList<String> signMessage, PrivateKey privateKey) throws Exception {
        return Builder.createSign(Builder.buildSignMessage(signMessage), privateKey);
    }

    public static String createSign(String signMessage, String keyPath) throws Exception {
        if (StringKit.isEmpty(signMessage)) {
            return null;
        }
        PrivateKey privateKey = Builder.getPrivateKey(keyPath);
        return Secure.encryptByPrivateKey(signMessage, privateKey);
    }

    public static String createSign(String signMessage, PrivateKey privateKey) throws Exception {
        if (StringKit.isEmpty(signMessage)) {
            return null;
        }
        return Secure.encryptByPrivateKey(signMessage, privateKey);
    }

    public static String getAuthorization(String mchId, String serialNo, String nonceStr, String timestamp, String signature, String authType) {
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("mchid", mchId);
        params.put("serial_no", serialNo);
        params.put("nonce_str", nonceStr);
        params.put("timestamp", timestamp);
        params.put("signature", signature);
        return authType.concat(" ").concat(Builder.createLinkString(params, ",", false, true));
    }

    public static String getPrivateKeyStr(String keyPath) throws Exception {
        return Secure.getPrivateKeyStr(Builder.getPrivateKey(keyPath));
    }

    public static PrivateKey getPrivateKey(String keyPath) throws Exception {
        String originalKey = FileKit.readString(keyPath);
        return Builder.getPrivateKeyByKeyContent(originalKey);
    }

    public static PrivateKey getPrivateKeyByKeyContent(String originalKey) throws Exception {
        String privateKey = originalKey.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
        return Secure.loadPrivateKey(privateKey);
    }

    public static X509Certificate getCertificate(InputStream inputStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            cert.checkValidity();
            return cert;
        }
        catch (CertificateExpiredException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", e);
        }
        catch (CertificateNotYetValidException e) {
            throw new RuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
    }

    public static String rsaEncryptOAEP(String data, X509Certificate certificate) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, certificate.getPublicKey());
            byte[] dataByte = data.getBytes(StandardCharsets.UTF_8);
            byte[] cipherData = cipher.doFinal(dataByte);
            return Base64.encode(cipherData);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u8bc1\u4e66", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalBlockSizeException("\u52a0\u5bc6\u539f\u4e32\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7214\u5b57\u8282");
        }
    }

    public static String rsaDecryptOAEP(String cipherText, PrivateKey privateKey) throws Exception {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(2, privateKey);
            byte[] data = Base64.decode(cipherText);
            return new String(cipher.doFinal(data), StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA v1.5/OAEP", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u79c1\u94a5", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new BadPaddingException("\u89e3\u5bc6\u5931\u8d25");
        }
    }

    public static InputStream getFileToStream(String classPath) {
        ClassPathResource resource = new ClassPathResource(classPath);
        return resource.getStream();
    }

    public static String getAbsolutePath(String classPath) {
        return new ClassPathResource(classPath).getAbsolutePath();
    }

    public static InputStream getCertFileInputStream(String path) throws IOException {
        if (StringKit.isBlank(path)) {
            return null;
        }
        File file = new File(path);
        if (file.exists()) {
            return new FileInputStream(file);
        }
        return Builder.getFileToStream(path);
    }

    public static enum ErrorCode {
        SUCCESS("0", "Success"),
        FAILURE("-1", "Failure"),
        NOT_IMPLEMENTED("5001", "Not Implemented"),
        PARAMETER_INCOMPLETE("5002", "Parameter incomplete"),
        UNSUPPORTED("5003", "Unsupported operation"),
        NO_AUTH_SOURCE("5004", "AuthDefaultSource cannot be null"),
        UNIDENTIFIED_PLATFORM("5005", "Unidentified platform"),
        ILLEGAL_REDIRECT_URI("5006", "Illegal redirect uri"),
        ILLEGAL_REQUEST("5007", "Illegal request"),
        ILLEGAL_CODE("5008", "Illegal code"),
        ILLEGAL_STATUS("5009", "Illegal state"),
        REQUIRED_REFRESH_TOKEN("5010", "The refresh token is required; it must not be null"),
        ILLEGAL_TOKEN("5011", "Invalid token");

        private String code;
        private String msg;

        public String getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        private ErrorCode(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }
    }
}

