/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.metric;

import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.http.Httpv;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.http.Httpz;
import org.aoju.bus.http.magic.GetBuilder;
import org.aoju.bus.http.magic.HttpResponse;
import org.aoju.bus.http.magic.PostBuilder;
import org.aoju.bus.http.magic.PutBuilder;
import org.aoju.bus.http.metric.http.SyncHttp;
import org.aoju.bus.pay.magic.Results;

public abstract class AbstractHttpDelegate {
    public static String post(String url, String data) {
        return Httpx.post(url, data, "application/x-www-form-urlencoded");
    }

    public static String get(String url, Map<String, Object> paramMap) {
        return Httpx.get(url, paramMap);
    }

    public static Results get(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = AbstractHttpDelegate.getToResponse(url, paramMap, headers);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public static Results post(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = AbstractHttpDelegate.postToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public static Results post(String url, String data, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = AbstractHttpDelegate.postToResponse(url, headers, data);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public static Results patch(String url, String data, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = AbstractHttpDelegate.patchToResponse(url, headers, data);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public static Results delete(String url, String data, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = AbstractHttpDelegate.deleteToResponse(url, headers, data);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public static Results put(String url, String data, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = AbstractHttpDelegate.putToResponse(url, headers, data);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public static String upload(String url, String data, String certPath, String certPass, String filePath, String protocol) {
        return null;
    }

    public static String upload(String url, String data, String certPath, String certPass, String filePath) {
        return null;
    }

    public static String post(String url, String data, String certPath, String certPass, String protocol) {
        return null;
    }

    public static String post(String url, String data, String certPath, String certPass) {
        return null;
    }

    public static String post(String url, String data, InputStream certFile, String certPass, String protocol) {
        return null;
    }

    public static String post(String url, String data, InputStream certFile, String certPass) {
        return null;
    }

    private static HttpResponse getToResponse(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        try {
            return ((GetBuilder)((GetBuilder)((GetBuilder)Httpz.get().url(url)).addHeaders(headers)).addParams(paramMap)).build().execute();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    private static HttpResponse postToResponse(String url, Map<String, String> headers, String data) {
        try {
            return ((PostBuilder)((PostBuilder)Httpz.post().url(url)).addHeaders(headers)).body(data).build().execute();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    private static HttpResponse postToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        try {
            return ((PostBuilder)((PostBuilder)((PostBuilder)Httpz.post().url(url)).addHeaders(headers)).addParams(paramMap)).build().execute();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    private static HttpResponse patchToResponse(String url, Map<String, String> headers, String data) {
        return null;
    }

    private static HttpResponse deleteToResponse(String url, Map<String, String> headers, String data) {
        return null;
    }

    private static HttpResponse putToResponse(String url, Map<String, String> headers, String data) {
        try {
            return ((PutBuilder)((PutBuilder)Httpz.put().url(url)).addHeaders(headers)).body(data).build().execute();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    private static KeyManager[] getKeyManager(String certPass, String certPath, InputStream certFile) throws Exception {
        KeyStore clientStore = KeyStore.getInstance("PKCS12");
        if (certFile != null) {
            clientStore.load(certFile, certPass.toCharArray());
        } else {
            clientStore.load(new FileInputStream(certPath), certPass.toCharArray());
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientStore, certPass.toCharArray());
        return kmf.getKeyManagers();
    }

    public String get(String url) {
        return Httpx.get(url);
    }

    public String post(String url, Map<String, Object> paramMap) {
        return Httpx.post(url, paramMap);
    }

    public Results patch(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = this.patchToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public Results delete(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = this.deleteToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    public Results put(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        Results response = new Results();
        HttpResponse httpResponse = this.putToResponse(url, headers, paramMap);
        response.setBody(httpResponse.body().toString());
        response.setStatus(httpResponse.code());
        response.setHeaders(httpResponse.headers().toMultimap());
        return response;
    }

    private HttpResponse patchToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        return (HttpResponse)((Object)((SyncHttp)((SyncHttp)Httpv.builder().build().sync(url).addBodyPara(paramMap)).addHeader(headers)).patch());
    }

    private HttpResponse deleteToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        return null;
    }

    private HttpResponse putToResponse(String url, Map<String, String> headers, Map<String, Object> paramMap) {
        try {
            return ((PutBuilder)((PutBuilder)((PutBuilder)Httpz.put().url(url)).addHeaders(headers)).addParams(paramMap)).build().execute();
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }
}

