/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.jdpay;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.XmlKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.pay.metric.WxPayKit;
import org.aoju.bus.pay.provider.jdpay.util.SignUtil;
import org.aoju.bus.pay.provider.jdpay.util.ThreeDesUtil;
import org.aoju.bus.pay.provider.jdpay.util.XmlEncryptUtil;
import org.w3c.dom.Document;

public class JdPayKit {
    public static String md5LowerCase(String data) {
        return Builder.md5Hex(data).toLowerCase();
    }

    public static String toJdXml(Map<String, String> params) {
        return WxPayKit.forEachMap(params, "<jdpay>", "</jdpay>").toString();
    }

    public static String encrypt(String rsaPrivateKey, String strDesKey, String genSignStr) {
        return XmlEncryptUtil.encrypt(rsaPrivateKey, strDesKey, genSignStr);
    }

    public static String decrypt(String rsaPubKey, String strDesKey, String encrypt) {
        return XmlEncryptUtil.decrypt(rsaPubKey, strDesKey, encrypt);
    }

    public static String decrypt(String rsaPubKey, String reqBody) {
        return XmlEncryptUtil.decrypt(rsaPubKey, reqBody);
    }

    public static String signRemoveSelectedKeys(Map<String, String> map, String rsaPriKey, List<String> unSignKeyList) {
        return SignUtil.signRemoveSelectedKeys(map, rsaPriKey, unSignKeyList);
    }

    public static String threeDesEncrypt(String desKey, String sourceData) {
        byte[] key = Base64.decode(desKey);
        return ThreeDesUtil.encrypt2HexStr(key, sourceData);
    }

    public static String threeDecDecrypt(String desKey, String sourceData) {
        byte[] key = Base64.decode(desKey);
        return ThreeDesUtil.decrypt4HexStr(key, sourceData);
    }

    public static Map<String, String> threeDesToMap(Map<String, String> map, String desKey) {
        HashMap<String, String> tempMap = new HashMap<String, String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringKit.isNotEmpty(value)) continue;
            if ("merchant".equals(name) || "version".equals(name) || "sign".equals(name)) {
                tempMap.put(name, value);
                continue;
            }
            tempMap.put(name, JdPayKit.threeDesEncrypt(desKey, value));
        }
        return tempMap;
    }

    public static Map<String, String> parseResp(String xml) {
        if (StringKit.isEmpty(xml)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(3);
        Document docResult = XmlKit.parseXml(xml);
        String code = (String)XmlKit.getByXPath("//jdpay/result/code", docResult, XPathConstants.STRING);
        String desc = (String)XmlKit.getByXPath("//jdpay/result/desc", docResult, XPathConstants.STRING);
        map.put("code", code);
        map.put("desc", desc);
        if ("000000".equals(code)) {
            String encrypt = (String)XmlKit.getByXPath("//jdpay/encrypt", docResult, XPathConstants.STRING);
            map.put("encrypt", encrypt);
        }
        return map;
    }
}

