/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.jdpay.models;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pay.magic.Property;
import org.aoju.bus.pay.provider.jdpay.JdPayKit;
import org.aoju.bus.pay.provider.jdpay.models.JdRequestModel;

public class JdPayEntity
extends Property {
    public Map<String, String> toMap() {
        String[] fieldNames = this.getFiledNames(this);
        HashMap<String, String> map = new HashMap<String, String>(fieldNames.length);
        for (String name : fieldNames) {
            String value = (String)this.getFieldValueByName(name, this);
            if (!StringKit.isNotEmpty(value)) continue;
            map.put(name, value);
        }
        return map;
    }

    public String[] getFiledNames(Object obj) {
        Field[] fields = obj.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }

    public Object getFieldValueByName(String fieldName, Object obj) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = new StringBuffer().append("get").append(firstLetter).append(fieldName.substring(1)).toString();
            Method method = obj.getClass().getMethod(getter, new Class[0]);
            return method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String genReqXml(String rsaPrivateKey, String strDesKey, String version, String merchant) {
        if (StringKit.isEmpty(version) || StringKit.isEmpty(merchant)) {
            throw new RuntimeException("version or merchant is empty");
        }
        String encrypt = JdPayKit.encrypt(rsaPrivateKey, strDesKey, JdPayKit.toJdXml(this.toMap()));
        Map<String, String> requestMap = JdRequestModel.builder().version(version).merchant(merchant).encrypt(encrypt).build().toMap();
        return JdPayKit.toJdXml(requestMap);
    }

    public Map<String, String> createSign(String rsaPrivateKey, String strDesKey) {
        Map<String, String> map = this.toMap();
        String sign = JdPayKit.signRemoveSelectedKeys(map, rsaPrivateKey, new ArrayList<String>());
        map.put("sign", sign);
        return JdPayKit.threeDesToMap(map, strDesKey);
    }
}

