/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.jdpay.util;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.pay.provider.jdpay.util.RSACoder;
import org.aoju.bus.pay.provider.jdpay.util.SHAUtil;

public class SignUtil {
    private static final List<String> unSignKeyList = Arrays.asList("merchantSign", "token", "version");

    public static String sign4SelectedKeys(Object object, String rsaPriKey, List<String> signKeyList) {
        String result = "";
        try {
            String sourceSignString = SignUtil.signString4SelectedKeys(object, signKeyList);
            String sha256SourceSignString = SHAUtil.Encrypt(sourceSignString, null);
            byte[] newsks = RSACoder.encryptByPrivateKey(sha256SourceSignString.getBytes(StandardCharsets.UTF_8), rsaPriKey);
            result = Base64.encode(newsks);
        }
        catch (Exception e) {
            throw new RuntimeException("sign4SelectedKeys>error", e);
        }
        return result;
    }

    public static String signRemoveSelectedKeys(Object object, String rsaPriKey, List<String> signKeyList) {
        String result = "";
        try {
            String sourceSignString = SignUtil.signString(object, signKeyList);
            String sha256SourceSignString = SHAUtil.Encrypt(sourceSignString, null);
            byte[] newK = RSACoder.encryptByPrivateKey(sha256SourceSignString.getBytes(StandardCharsets.UTF_8), rsaPriKey);
            result = Base64.encode(newK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String signString(Object object, List<String> unSignKeyList) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, Object> map = SignUtil.objectToMap(object);
        StringBuilder sb = new StringBuilder();
        for (String str : unSignKeyList) {
            map.remove(str);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String value;
            if (entry.getValue() == null || (value = (String)entry.getValue()).trim().length() <= 0) continue;
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        String result = sb.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String signString4SelectedKeys(Object object, List<String> signedKeyList) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, Object> map = SignUtil.objectToMap(object);
        if (map == null || map.isEmpty() || signedKeyList == null || signedKeyList.isEmpty()) {
            return null;
        }
        TreeMap<String, Object> signMap = new TreeMap<String, Object>();
        StringBuilder sb = new StringBuilder();
        for (String str : signedKeyList) {
            Object o = map.get(str);
            if (o != null) {
                signMap.put(str, o);
                continue;
            }
            signMap.put(str, "");
        }
        for (Map.Entry entry : signMap.entrySet()) {
            sb.append(entry.getKey() + "=" + (entry.getValue() == null ? "" : entry.getValue()) + "&");
        }
        String result = sb.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static TreeMap<String, Object> objectToMap(Object object) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        if (object instanceof Map) {
            Map objectMap = (Map)object;
            for (String str : objectMap.keySet()) {
                map.put(str, objectMap.get(str));
            }
            return map;
        }
        for (Class<?> cls = object.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = cls.getDeclaredFields()) {
                f.setAccessible(true);
                map.put(f.getName(), f.get(object));
            }
        }
        return map;
    }

    public static String sign4PCString(Object object, List<String> unSignKeyList) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, Object> map = SignUtil.objectToMap(object);
        StringBuilder sb = new StringBuilder();
        for (String str : unSignKeyList) {
            map.remove(str);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append(entry.getKey() + "=" + (entry.getValue() == null ? "" : entry.getValue()) + "&");
        }
        String result = sb.toString();
        if (result.endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

