/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.jdpay.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class ThreeDesUtil {
    public static final byte[] DEFAULT_KEY = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52};

    public static byte[] encrypt(byte[] keybyte, byte[] src) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, "DESede");
            Cipher c1 = Cipher.getInstance("DESede/ECB/NoPadding");
            c1.init(1, deskey);
            return c1.doFinal(src);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchPaddingException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return null;
    }

    private static byte[] decrypt(byte[] keybyte, byte[] src) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, "DESede");
            Cipher c1 = Cipher.getInstance("DESede/ECB/NoPadding");
            c1.init(2, deskey);
            return c1.doFinal(src);
        }
        catch (NoSuchAlgorithmException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchPaddingException e2) {
            e2.printStackTrace();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        return null;
    }

    private static String byte2Hex(byte[] b) {
        Object hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? (String)hs + "0" + stmp : (String)hs + stmp;
            if (n >= b.length - 1) continue;
            hs = (String)hs + ":";
        }
        return ((String)hs).toUpperCase();
    }

    public static String encrypt2HexStr(byte[] keys, String sourceData) {
        int i;
        byte[] source = sourceData.getBytes(StandardCharsets.UTF_8);
        int merchantData = source.length;
        int x = (merchantData + 4) % 8;
        int y = x == 0 ? 0 : 8 - x;
        byte[] sizeByte = ThreeDesUtil.intToByteArray(merchantData);
        byte[] resultByte = new byte[merchantData + 4 + y];
        resultByte[0] = sizeByte[0];
        resultByte[1] = sizeByte[1];
        resultByte[2] = sizeByte[2];
        resultByte[3] = sizeByte[3];
        for (i = 0; i < merchantData; ++i) {
            resultByte[4 + i] = source[i];
        }
        for (i = 0; i < y; ++i) {
            resultByte[merchantData + 4 + i] = 0;
        }
        byte[] desdata = ThreeDesUtil.encrypt(keys, resultByte);
        return ThreeDesUtil.bytes2Hex(desdata);
    }

    public static String decrypt4HexStr(byte[] keys, String data) {
        byte[] hexSourceData = new byte[]{};
        try {
            hexSourceData = ThreeDesUtil.hex2byte(data.getBytes(StandardCharsets.UTF_8));
            byte[] unDesResult = ThreeDesUtil.decrypt(keys, hexSourceData);
            byte[] dataSizeByte = new byte[]{unDesResult[0], unDesResult[1], unDesResult[2], unDesResult[3]};
            int dsb = ThreeDesUtil.byteArrayToInt(dataSizeByte, 0);
            if (dsb > 16384) {
                throw new RuntimeException("msg over MAX_MSG_LENGTH or msg error");
            }
            byte[] tempData = new byte[dsb];
            for (int i = 0; i < dsb; ++i) {
                tempData[i] = unDesResult[4 + i];
            }
            return ThreeDesUtil.hex2bin(ThreeDesUtil.toHexString(tempData));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String hex2bin(String hex) throws UnsupportedEncodingException {
        String digital = "0123456789abcdef";
        char[] hex2char = hex.toCharArray();
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int temp = digital.indexOf(hex2char[2 * i]) * 16;
            bytes[i] = (byte)((temp += digital.indexOf(hex2char[2 * i + 1])) & 0xFF);
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static String toHexString(byte[] ba) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            str.append(String.format("%x", ba[i]));
        }
        return str.toString();
    }

    private static String bytes2Hex(byte[] bts) {
        Object des = "";
        String tmp = null;
        for (int i = 0; i < bts.length; ++i) {
            tmp = Integer.toHexString(bts[i] & 0xFF);
            if (tmp.length() == 1) {
                des = (String)des + "0";
            }
            des = (String)des + tmp;
        }
        return des;
    }

    public static byte[] hex2byte(byte[] b) {
        if (b.length % 2 != 0) {
            throw new IllegalArgumentException("\u957f\u5ea6\u4e0d\u662f\u5076\u6570");
        }
        byte[] b2 = new byte[b.length / 2];
        for (int n = 0; n < b.length; n += 2) {
            String item = new String(b, n, 2);
            b2[n / 2] = (byte)Integer.parseInt(item, 16);
        }
        b = null;
        return b2;
    }

    private static byte[] intToByteArray(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    private static int byteArrayToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    public static void main(String[] args) {
        String szSrc = "This is a 3DES test. \u6d4b\u8bd5abcdf";
        System.out.println("\u52a0\u5bc6\u524d\u7684\u5b57\u7b26\u4e32:" + szSrc);
        byte[] encoded = new byte[]{};
        System.out.println("\u52a0\u5bc6\u524d\u957f\u5ea6:" + szSrc.getBytes(StandardCharsets.UTF_8).length);
        System.out.println("\u52a0\u5bc6\u524dHEX:" + ThreeDesUtil.bytes2Hex(szSrc.getBytes(StandardCharsets.UTF_8)));
        encoded = ThreeDesUtil.encrypt(DEFAULT_KEY, szSrc.getBytes(StandardCharsets.UTF_8));
        System.out.println("\u52a0\u5bc6\u540e\u957f\u5ea6:" + encoded.length);
        System.out.println("\u52a0\u5bc6\u540e\u7684\u5b57\u7b26\u4e32:" + new String(encoded, StandardCharsets.UTF_8));
        byte[] srcBytes = ThreeDesUtil.decrypt(DEFAULT_KEY, encoded);
        System.out.println("\u89e3\u5bc6\u540eHEX:" + ThreeDesUtil.bytes2Hex(srcBytes));
        System.out.println("\u89e3\u5bc6\u540e\u7684\u5b57\u7b26\u4e32:" + new String(srcBytes));
    }
}

