/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.pay.provider.paypal;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.pay.Builder;
import org.aoju.bus.pay.Context;
import org.aoju.bus.pay.magic.Results;
import org.aoju.bus.pay.metric.HttpKit;
import org.aoju.bus.pay.provider.paypal.AccessToken;
import org.aoju.bus.pay.provider.paypal.AccessTokenKit;
import org.aoju.bus.pay.provider.paypal.PayPalApiUrl;

public class PaypalProvider {
    public static String getReqUrl(PayPalApiUrl payPalApiUrl, boolean isSandBox) {
        return (isSandBox ? PayPalApiUrl.SANDBOX_GATEWAY.getUrl() : PayPalApiUrl.LIVE_GATEWAY.getUrl()).concat(payPalApiUrl.getUrl());
    }

    public static Results getToken(Context context) {
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        headers.put("Authorization", "Basic ".concat(Base64.encode(context.getClientId().concat(":").concat(context.getSecret()).getBytes(StandardCharsets.UTF_8))));
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("grant_type", "client_credentials");
        return PaypalProvider.post(PaypalProvider.getReqUrl(PayPalApiUrl.GET_TOKEN, context.isSandBox()), params, headers);
    }

    public static Results createOrder(Context context, String data) {
        AccessToken accessToken = AccessTokenKit.get(context.getClientId());
        return PaypalProvider.post(PaypalProvider.getReqUrl(PayPalApiUrl.CHECKOUT_ORDERS, context.isSandBox()), data, PaypalProvider.getBaseHeaders(accessToken));
    }

    public static Results updateOrder(Context context, String id, String data) {
        AccessToken accessToken = AccessTokenKit.get(context.getClientId());
        String url = PaypalProvider.getReqUrl(PayPalApiUrl.CHECKOUT_ORDERS, context.isSandBox()).concat("/").concat(id);
        return PaypalProvider.patch(url, data, PaypalProvider.getBaseHeaders(accessToken));
    }

    public static Results queryOrder(Context context, String orderId) {
        AccessToken accessToken = AccessTokenKit.get(context.getClientId());
        String url = PaypalProvider.getReqUrl(PayPalApiUrl.CHECKOUT_ORDERS, context.isSandBox()).concat("/").concat(orderId);
        return PaypalProvider.get(url, null, PaypalProvider.getBaseHeaders(accessToken));
    }

    public static Results captureOrder(Context context, String id, String data) {
        AccessToken accessToken = AccessTokenKit.get(context.getClientId());
        String url = String.format(PaypalProvider.getReqUrl(PayPalApiUrl.CAPTURE_ORDER, context.isSandBox()), id);
        return PaypalProvider.post(url, data, PaypalProvider.getBaseHeaders(accessToken));
    }

    public static Results captureQuery(Context context, String captureId) {
        AccessToken accessToken = AccessTokenKit.get(context.getClientId());
        String url = String.format(PaypalProvider.getReqUrl(PayPalApiUrl.CAPTURE_QUERY, context.isSandBox()), captureId);
        return PaypalProvider.get(url, null, PaypalProvider.getBaseHeaders(accessToken));
    }

    public static Results refund(Context context, String captureId, String data) {
        AccessToken accessToken = AccessTokenKit.get(context.getClientId());
        String url = String.format(PaypalProvider.getReqUrl(PayPalApiUrl.REFUND, context.isSandBox()), captureId);
        return PaypalProvider.post(url, data, PaypalProvider.getBaseHeaders(accessToken));
    }

    public static Results refundQuery(Context context, String id) {
        AccessToken accessToken = AccessTokenKit.get(context.getClientId());
        String url = String.format(PaypalProvider.getReqUrl(PayPalApiUrl.REFUND_QUERY, context.isSandBox()), id);
        return PaypalProvider.get(url, null, PaypalProvider.getBaseHeaders(accessToken));
    }

    public static Results post(String url, Map<String, Object> params, Map<String, String> headers) {
        return HttpKit.post(url, params, headers);
    }

    public static Results get(String url, Map<String, Object> params, Map<String, String> headers) {
        return HttpKit.get(url, params, headers);
    }

    public static Results post(String url, String data, Map<String, String> headers) {
        return HttpKit.post(url, data, headers);
    }

    public static Results patch(String url, String data, Map<String, String> headers) {
        return HttpKit.patch(url, data, headers);
    }

    public static Map<String, String> getBaseHeaders(AccessToken accessToken) {
        return PaypalProvider.getBaseHeaders(accessToken, Builder.generateStr(), null, null);
    }

    public static Map<String, String> getBaseHeaders(AccessToken accessToken, String payPalRequestId, String payPalPartnerAttributionId, String prefer) {
        if (accessToken == null || StringKit.isEmpty(accessToken.getTokenType()) || StringKit.isEmpty(accessToken.getAccessToken())) {
            throw new RuntimeException("accessToken is null");
        }
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", accessToken.getTokenType().concat(" ").concat(accessToken.getAccessToken()));
        if (StringKit.isNotEmpty(payPalRequestId)) {
            headers.put("PayPal-Request-Id", payPalRequestId);
        }
        if (StringKit.isNotEmpty(payPalPartnerAttributionId)) {
            headers.put("PayPal-Partner-Attribution-Id", payPalPartnerAttributionId);
        }
        if (StringKit.isNotEmpty(prefer)) {
            headers.put("Prefer", prefer);
        }
        return headers;
    }
}

