/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.sensitive;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.sensitive.Builder;
import org.aoju.bus.sensitive.annotation.Strategy;
import org.aoju.bus.sensitive.provider.StrategyProvider;
import org.aoju.bus.sensitive.strategy.AddressStrategy;
import org.aoju.bus.sensitive.strategy.BandCardStrategy;
import org.aoju.bus.sensitive.strategy.BuiltInStrategy;
import org.aoju.bus.sensitive.strategy.CitizenIdStrategy;
import org.aoju.bus.sensitive.strategy.CnapsStrategy;
import org.aoju.bus.sensitive.strategy.DafaultStrategy;
import org.aoju.bus.sensitive.strategy.EmailStrategy;
import org.aoju.bus.sensitive.strategy.MobileStrategy;
import org.aoju.bus.sensitive.strategy.NameStrategy;
import org.aoju.bus.sensitive.strategy.NoneStrategy;
import org.aoju.bus.sensitive.strategy.PasswordStrategy;
import org.aoju.bus.sensitive.strategy.PayStrategy;
import org.aoju.bus.sensitive.strategy.PhoneStrategy;

public final class Registry {
    private static Map<Builder.Type, StrategyProvider> STRATEGY_CACHE = new ConcurrentHashMap<Builder.Type, StrategyProvider>();

    public static void register(Builder.Type name, StrategyProvider object) {
        if (STRATEGY_CACHE.containsKey((Object)name)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + name);
        }
        Class<?> clazz = object.getClass();
        if (STRATEGY_CACHE.containsKey(clazz.getSimpleName())) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u7c7b\u578b\u7684\u7ec4\u4ef6\uff1a" + clazz);
        }
        STRATEGY_CACHE.putIfAbsent(name, object);
    }

    public static StrategyProvider require(Builder.Type name) {
        StrategyProvider sensitiveProvider = STRATEGY_CACHE.get((Object)name);
        if (ObjectKit.isEmpty(sensitiveProvider)) {
            throw new IllegalArgumentException("none sensitiveProvider be found!, type:" + name);
        }
        return sensitiveProvider;
    }

    public static StrategyProvider require(Class<? extends Annotation> annotationClass) {
        StrategyProvider strategy = STRATEGY_CACHE.get(annotationClass);
        if (ObjectKit.isEmpty(strategy)) {
            throw new InstrumentException("\u4e0d\u652f\u6301\u7684\u7cfb\u7edf\u5185\u7f6e\u65b9\u6cd5,\u7528\u6237\u8bf7\u52ff\u5728\u81ea\u5b9a\u4e49\u6ce8\u89e3\u4e2d\u4f7f\u7528[BuiltInStrategy]!");
        }
        return strategy;
    }

    public static StrategyProvider require(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Strategy sensitiveStrategy = annotation.annotationType().getAnnotation(Strategy.class);
            if (!ObjectKit.isNotEmpty(sensitiveStrategy)) continue;
            Class<? extends StrategyProvider> clazz = sensitiveStrategy.value();
            StrategyProvider strategy = BuiltInStrategy.class.equals(clazz) ? Registry.require(annotation.annotationType()) : ClassKit.newInstance(clazz);
            return strategy;
        }
        return null;
    }

    public boolean contains(String name) {
        return STRATEGY_CACHE.containsKey(name);
    }

    static {
        Registry.register(Builder.Type.ADDRESS, new AddressStrategy());
        Registry.register(Builder.Type.BANK_CARD, new BandCardStrategy());
        Registry.register(Builder.Type.CNAPS_CODE, new CnapsStrategy());
        Registry.register(Builder.Type.DEFAUL, new DafaultStrategy());
        Registry.register(Builder.Type.EMAIL, new EmailStrategy());
        Registry.register(Builder.Type.CITIZENID, new CitizenIdStrategy());
        Registry.register(Builder.Type.MOBILE, new MobileStrategy());
        Registry.register(Builder.Type.NAME, new NameStrategy());
        Registry.register(Builder.Type.NONE, new NoneStrategy());
        Registry.register(Builder.Type.PASSWORD, new PasswordStrategy());
        Registry.register(Builder.Type.PAY_SIGN_NO, new PayStrategy());
        Registry.register(Builder.Type.PHONE, new PhoneStrategy());
    }
}

