/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.setting.format;

import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.setting.format.AbstractFormatter;
import org.aoju.bus.setting.format.CommentFormatter;
import org.aoju.bus.setting.magic.IniComment;
import org.aoju.bus.setting.magic.IniSection;
import org.aoju.bus.setting.magic.IniSectionImpl;

public class SectionFormatter
extends AbstractFormatter<IniSection> {
    private char head;
    private char end;

    public SectionFormatter(CommentFormatter commentElementFormatter) {
        super(commentElementFormatter);
        this.head = (char)91;
        this.end = (char)93;
    }

    public SectionFormatter() {
        this.head = (char)91;
        this.end = (char)93;
    }

    public SectionFormatter(char head, char end, CommentFormatter commentElementFormatter) {
        super(commentElementFormatter);
        this.head = head;
        this.end = end;
    }

    public SectionFormatter(char head, char end) {
        this.head = head;
        this.end = end;
    }

    @Override
    public boolean check(String value) {
        return value.charAt(0) == this.head;
    }

    @Override
    public IniSection format(String value, int line) {
        int indexOfEnd = value.indexOf(this.end);
        if (indexOfEnd <= 0) {
            throw new InstrumentException("can not found the end character '" + this.end + "' for section line " + line + " : " + value);
        }
        String sectionValue = value.substring(0, indexOfEnd + 1).trim();
        String endOfValue = value.substring(indexOfEnd + 1).trim();
        IniComment comment = null;
        if (endOfValue.length() > 0) {
            CommentFormatter commentElementFormatter = this.getCommentElementFormatter();
            if (commentElementFormatter.check(endOfValue)) {
                comment = commentElementFormatter.format(endOfValue, line);
            } else {
                throw new InstrumentException("can not format the value end of section value (" + line + ":" + (indexOfEnd + 1) + ") :" + endOfValue);
            }
        }
        return new IniSectionImpl(sectionValue.substring(1, indexOfEnd), sectionValue, line, comment);
    }
}

