/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.sensitive;

import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.mapper.handler.AbstractSqlHandler;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveResultSetHandler
extends AbstractSqlHandler
implements Interceptor {
    private boolean debug;
    private String type;
    private String key;

    public Object intercept(Invocation invocation) throws Throwable {
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        if (this.debug) {
            ResultSetHandler statementHandler = (ResultSetHandler)SensitiveResultSetHandler.realTarget(invocation.getTarget());
            MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
            MappedStatement mappedStatement = SensitiveResultSetHandler.getMappedStatement(metaObject, "mappedStatement");
            ResultMap resultMap = mappedStatement.getResultMaps().isEmpty() ? null : (ResultMap)mappedStatement.getResultMaps().get(0);
            Sensitive sensitive = results.get(0).getClass().getAnnotation(Sensitive.class);
            if (ObjectKit.isEmpty(sensitive)) {
                return results;
            }
            Map<String, Privacy> privacyMap = this.getSensitiveByResultMap(resultMap);
            for (Object obj : results) {
                if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "OUT".equals(sensitive.stage()))) {
                    MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(obj);
                    for (Map.Entry<String, Privacy> entry : privacyMap.entrySet()) {
                        String property;
                        String value;
                        Privacy privacy = entry.getValue();
                        if (!ObjectKit.isNotEmpty(privacy) || !StringKit.isNotEmpty(privacy.value()) || !"ALL".equals(privacy.value()) && !"OUT".equals(privacy.value()) || !StringKit.isNotEmpty(value = (String)objMetaObject.getValue(property = entry.getKey()))) continue;
                        Logger.debug("Query data decryption enabled ...", new Object[0]);
                        String decryptValue = Builder.decrypt(this.type, this.key, value, Charset.UTF_8);
                        objMetaObject.setValue(property, (Object)decryptValue);
                    }
                }
                if (!"ALL".equals(sensitive.value()) && !"SENS".equals(sensitive.value()) || !"ALL".equals(sensitive.stage()) && !"OUT".equals(sensitive.stage())) continue;
                Logger.debug("Query data sensitive enabled ...", new Object[0]);
                org.aoju.bus.sensitive.Builder.on(obj);
            }
        }
        return results;
    }

    public Object plugin(Object object) {
        if (object instanceof ResultSetHandler) {
            return Plugin.wrap((Object)object, (Interceptor)this);
        }
        return object;
    }

    public void setProperties(Properties properties) {
        this.debug = BooleanKit.toBoolean(properties.getProperty("debug"));
        this.key = properties.getProperty("key");
        this.type = properties.getProperty("type");
    }

    private Map<String, Privacy> getSensitiveByResultMap(ResultMap resultMap) {
        if (null == resultMap) {
            return new HashMap<String, Privacy>(16);
        }
        return this.getSensitiveByType(resultMap.getType());
    }

    private Map<String, Privacy> getSensitiveByType(Class<?> clazz) {
        HashMap<String, Privacy> sensitiveFieldMap = new HashMap<String, Privacy>(16);
        for (Field field : clazz.getDeclaredFields()) {
            Privacy sensitiveField = field.getAnnotation(Privacy.class);
            if (null == sensitiveField) continue;
            sensitiveFieldMap.put(field.getName(), sensitiveField);
        }
        return sensitiveFieldMap;
    }
}

