/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aoju.bus.core.lang.ansi.AnsiBackground;
import org.aoju.bus.core.lang.ansi.AnsiEncoder;
import org.aoju.bus.extra.servlet.ServletKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.starter.wrapper.CacheRequestWrapper;
import org.aoju.bus.starter.wrapper.CacheResponseWrapper;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Component
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class GenieWrapperHandler
implements HandlerInterceptor {
    private static void isHandle(HttpServletRequest request, String method) {
        switch (method) {
            case "ALL": {
                method = AnsiEncoder.encode(AnsiBackground.WHITE, " %s ", method);
                break;
            }
            case "GET": {
                method = AnsiEncoder.encode(AnsiBackground.GREEN, " %s ", method);
                break;
            }
            case "POST": {
                method = AnsiEncoder.encode(AnsiBackground.MAGENTA, " %s ", method);
                break;
            }
            case "DELETE": {
                method = AnsiEncoder.encode(AnsiBackground.BLUE, " %s ", method);
                break;
            }
            case "PUT": {
                method = AnsiEncoder.encode(AnsiBackground.RED, " %s ", method);
                break;
            }
            case "OPTIONS": {
                method = AnsiEncoder.encode(AnsiBackground.YELLOW, " %s ", method);
                break;
            }
            case "BEFORE": {
                method = AnsiEncoder.encode(AnsiBackground.BLACK, " %s ", method);
                break;
            }
            case "AFTER": {
                method = AnsiEncoder.encode(AnsiBackground.CYAN, " %s ", method);
            }
        }
        Logger.info("{} {} {}", "==>", ServletKit.getClientIP(request, new String[0]), method, request.getRequestURL().toString());
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String method = request.getMethod().toUpperCase();
        GenieWrapperHandler.isHandle(request, method);
        if (("GET".equals(method) || "POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && request instanceof CacheRequestWrapper) {
            CacheRequestWrapper cacheRequestWrapper = (CacheRequestWrapper)request;
            Logger.info("==> {}", new String(cacheRequestWrapper.getBody()));
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        String method = request.getMethod();
        if (("POST".equals(method) || "PATCH".equals(method) || "PUT".equals(method)) && response instanceof CacheResponseWrapper) {
            CacheResponseWrapper cacheResponseWrapper = (CacheResponseWrapper)response;
            Logger.info("<== {}", new String(cacheResponseWrapper.getBody()).length());
        }
    }

    @Bean
    WebMvcConfigurer enableGenieHandler() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new GenieWrapperHandler());
            }
        };
    }
}

