/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectResult;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Builder;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Message;
import org.aoju.bus.storage.magic.Property;
import org.aoju.bus.storage.provider.AbstractProvider;

public class AliYunOssProvider
extends AbstractProvider {
    private OSSClient client;

    public AliYunOssProvider(Context context) {
        this.context = context;
        Assert.notBlank(this.context.getPrefix(), "[prefix] not defined", new Object[0]);
        Assert.notBlank(this.context.getEndpoint(), "[endpoint] not defined", new Object[0]);
        Assert.notBlank(this.context.getBucket(), "[bucket] not defined", new Object[0]);
        Assert.notBlank(this.context.getAccessKey(), "[accessKey] not defined", new Object[0]);
        Assert.notBlank(this.context.getSecretKey(), "[secretKey] not defined", new Object[0]);
        Assert.notNull(this.context.isSecure(), "[secure] not defined", new Object[0]);
        this.client = new OSSClient(this.context.getEndpoint(), (CredentialsProvider)new DefaultCredentialProvider(this.context.getAccessKey(), this.context.getSecretKey()), null);
        if (!this.client.doesBucketExist(this.context.getBucket())) {
            this.client.createBucket(this.context.getBucket());
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(this.context.getBucket());
            createBucketRequest.setCannedACL(this.context.isSecure() ? CannedAccessControlList.Private : CannedAccessControlList.PublicRead);
            this.client.createBucket(createBucketRequest);
        }
    }

    @Override
    public Message download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Message download(String bucket, String fileName) {
        Message message;
        OSSObject ossObject = this.client.getObject(bucket, fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));
        try {
            String line;
            while (null != (line = reader.readLine())) {
            }
            message = Message.builder().data(reader).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Logger.error("file download failed", e.getMessage());
                return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
            }
        }
        reader.close();
        return message;
    }

    @Override
    public Message download(String fileName, File file) {
        return this.download(this.context.getBucket(), fileName, file);
    }

    @Override
    public Message download(String bucket, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucket, fileName), file);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
    }

    @Override
    public Message list() {
        ListObjectsRequest request = new ListObjectsRequest(this.context.getBucket());
        ObjectListing objectListing = this.client.listObjects(request);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(objectListing.getObjectSummaries().stream().map(item -> {
            Property storageItem = new Property();
            storageItem.setName(item.getKey());
            storageItem.setSize(StringKit.toString(item.getSize()));
            HashMap extend = Maps.newHashMap();
            extend.put("tag", item.getETag());
            extend.put("storageClass", item.getStorageClass());
            extend.put("lastModified", item.getLastModified());
            storageItem.setExtend(extend);
            return storageItem;
        }).collect(Collectors.toList())).build();
    }

    @Override
    public Message rename(String oldName, String newName) {
        return this.rename(this.context.getBucket(), oldName, newName);
    }

    @Override
    public Message rename(String bucket, String oldName, String newName) {
        boolean keyExists = true;
        try {
            this.client.getObjectMetadata(bucket, oldName);
        }
        catch (Exception e) {
            keyExists = false;
        }
        if (keyExists) {
            this.client.copyObject(bucket, oldName, bucket, newName);
        }
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
    }

    @Override
    public Message upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Message upload(String bucket, String fileName, InputStream content) {
        try {
            byte[] bytes = new byte[content.available()];
            return this.upload(this.context.getBucket(), fileName, bytes);
        }
        catch (IOException e) {
            Logger.error("file upload failed ", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message upload(String bucket, String fileName, byte[] content) {
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        try {
            PutObjectResult objectResult = this.client.putObject(bucket, fileName, (InputStream)bis);
            ResponseMessage response = objectResult.getResponse();
            if (!response.isSuccessful()) {
                return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(response.getErrorResponseAsString()).build();
            }
            return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).data(Property.builder().name(fileName).size("" + response.getContentLength()).path(response.getUri())).build();
        }
        catch (Exception e) {
            this.client.putObject(bucket, fileName, (InputStream)bis);
            Logger.error("file upload failed ", e.getMessage());
            return Message.builder().errcode(Builder.ErrorCode.FAILURE.getCode()).errmsg(Builder.ErrorCode.FAILURE.getMsg()).build();
        }
    }

    @Override
    public Message remove(String fileName) {
        return this.remove(this.context.getBucket(), fileName);
    }

    @Override
    public Message remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
    }

    @Override
    public Message remove(String bucket, Path path) {
        this.remove(bucket, path.toString());
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).errmsg(Builder.ErrorCode.SUCCESS.getMsg()).build();
    }
}

