/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2022 aoju.org and other contributors.                      *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.aoju.bus.core.annotation;

import org.aoju.bus.core.lang.Normal;

import java.lang.annotation.*;

/**
 * 日志追溯
 *
 * @author Kimi Liu
 * @since Java 17+
 */
@Target({ElementType.PARAMETER, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Trace {

    /**
     * @return 业务标题
     */
    String value() default Normal.EMPTY;

    /**
     * @return 业务编号
     */
    String id() default Normal.EMPTY;

    /**
     * @return 业务模块
     */
    String module() default Normal.EMPTY;

    /**
     * @return 业务功能
     */
    String business() default Normal.EMPTY;

    /**
     * @return 参数信息
     */
    String params() default Normal.EMPTY;

    /**
     * @return 操作人类别
     */
    String operator() default Normal.EMPTY;

    /**
     * @return 扩展信息
     */
    String extend() default Normal.EMPTY;

    /**
     * @return 是否保存请求参数
     */
    boolean isSaveRequest() default true;

}