/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.base.entity;

import java.util.List;
import java.util.Objects;
import javax.persistence.Transient;
import org.aoju.bus.base.entity.Tracer;
import org.aoju.bus.core.key.ObjectID;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class BaseEntity
extends Tracer {
    private static final long serialVersionUID = 1L;
    protected String status;
    protected String creator;
    protected String created;
    protected String modifier;
    protected String modified;
    @Transient
    protected transient String params;
    @Transient
    protected transient Integer pageNo;
    @Transient
    protected transient Integer pageSize;
    @Transient
    protected transient String orderBy;

    public static <T extends BaseEntity> void setAccess(T source, T target) {
        if (Objects.isNull(source) || Objects.isNull(target)) {
            return;
        }
        target.setX_org_id(source.getX_org_id());
        target.setX_user_id(source.getX_user_id());
    }

    public static <T extends BaseEntity> void setAccess(T source, T ... target) {
        if (Objects.isNull(source) || ArrayKit.isEmpty(target)) {
            return;
        }
        for (T targetEntity : target) {
            BaseEntity.setAccess(source, targetEntity);
        }
    }

    public static <S extends BaseEntity, E extends BaseEntity> void setAccess(S source, List<E> target) {
        if (Objects.isNull(source) || CollKit.isEmpty(target)) {
            return;
        }
        target.forEach(targetEntity -> BaseEntity.setAccess(source, targetEntity));
    }

    public static <T extends BaseEntity> void resetIntField(T entity, String[] fields, String[] values) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!"".equals(values[i]) || !ReflectKit.hasField(entity, field)) continue;
            ReflectKit.invokeSetter(entity, field, null);
        }
    }

    public <T> void setCreateInfo(T entity) {
        String id = ObjectKit.isEmpty(this.getValue(entity, "id")) ? ObjectID.id() : (String)this.getValue(entity, "id");
        String timestamp = StringKit.toString(DateKit.timestamp());
        String[] fields = new String[]{"id", "created"};
        Object[] value = new Object[]{id, timestamp};
        if (ObjectKit.isEmpty(this.getValue(entity, "creator"))) {
            fields = new String[]{"id", "creator", "created"};
            value = new Object[]{id, ObjectKit.isEmpty(this.getValue(entity, "x_user_id")) ? "-1" : this.getValue(entity, "x_user_id"), timestamp};
        }
        this.setValue(entity, fields, value);
    }

    public <T> void setUpdatedInfo(T entity) {
        String timestamp = StringKit.toString(DateKit.timestamp());
        String[] fields = new String[]{"modified"};
        Object[] value = new Object[]{timestamp};
        if (ObjectKit.isEmpty(this.getValue(entity, "modifier"))) {
            fields = new String[]{"modifier", "modified"};
            value = new Object[]{ObjectKit.isEmpty(this.getValue(entity, "x_user_id")) ? "-1" : this.getValue(entity, "x_user_id"), timestamp};
        }
        this.setValue(entity, fields, value);
    }

    public <T> void setCreatAndUpdatInfo(T entity) {
        this.setCreateInfo(entity);
        this.setUpdatedInfo(entity);
    }

    public <T> boolean isPKNotNull(T entity, String field) {
        if (!ReflectKit.hasField(entity, field)) {
            return false;
        }
        Object value = ReflectKit.getFieldValue(entity, field);
        return null != value && !"".equals(value);
    }

    public <T> Object getValue(T entity, String field) {
        if (ReflectKit.hasField(entity, field)) {
            Object object = ReflectKit.invokeGetter(entity, field);
            return null != object ? object.toString() : null;
        }
        return null;
    }

    public <T> void setValue(T entity, String[] fields, Object[] value) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!ReflectKit.hasField(entity, field)) continue;
            ReflectKit.invokeSetter(entity, field, value[i]);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCreated() {
        return this.created;
    }

    public String getModifier() {
        return this.modifier;
    }

    public String getModified() {
        return this.modified;
    }

    public String getParams() {
        return this.params;
    }

    public Integer getPageNo() {
        return this.pageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public String toString() {
        return "BaseEntity(status=" + this.getStatus() + ", creator=" + this.getCreator() + ", created=" + this.getCreated() + ", modifier=" + this.getModifier() + ", modified=" + this.getModified() + ", params=" + this.getParams() + ", pageNo=" + this.getPageNo() + ", pageSize=" + this.getPageSize() + ", orderBy=" + this.getOrderBy() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseEntity)) {
            return false;
        }
        BaseEntity other = (BaseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        String this$modified = this.getModified();
        String other$modified = other.getModified();
        return !(this$modified == null ? other$modified != null : !this$modified.equals(other$modified));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        String $modified = this.getModified();
        result = result * 59 + ($modified == null ? 43 : $modified.hashCode());
        return result;
    }
}

