/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.aoju.bus.cache.annotation.CacheKey;
import org.aoju.bus.cache.annotation.Cached;
import org.aoju.bus.cache.annotation.CachedGet;
import org.aoju.bus.cache.annotation.Invalid;
import org.aoju.bus.cache.magic.AnnoHolder;
import org.aoju.bus.cache.magic.CachePair;
import org.aoju.bus.cache.magic.MethodHolder;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.logger.Logger;

public class CacheInfoContainer {
    private static final ConcurrentMap<Method, CachePair<AnnoHolder, MethodHolder>> cacheMap = new ConcurrentHashMap<Method, CachePair<AnnoHolder, MethodHolder>>();

    public static CachePair<AnnoHolder, MethodHolder> getCacheInfo(Method method) {
        return cacheMap.computeIfAbsent(method, CacheInfoContainer::doGetMethodInfo);
    }

    private static CachePair<AnnoHolder, MethodHolder> doGetMethodInfo(Method method) {
        AnnoHolder annoHolder = CacheInfoContainer.getAnnoHolder(method);
        MethodHolder methodHolder = CacheInfoContainer.getMethodHolder(method, annoHolder);
        return CachePair.of(annoHolder, methodHolder);
    }

    private static AnnoHolder getAnnoHolder(Method method) {
        AnnoHolder.Builder builder = AnnoHolder.Builder.newBuilder(method);
        Annotation[][] pAnnotations = method.getParameterAnnotations();
        CacheInfoContainer.scanKeys(builder, pAnnotations);
        if (method.isAnnotationPresent(Cached.class)) {
            CacheInfoContainer.scanCached(builder, method.getAnnotation(Cached.class));
        } else if (method.isAnnotationPresent(CachedGet.class)) {
            CacheInfoContainer.scanCachedGet(builder, method.getAnnotation(CachedGet.class));
        } else {
            CacheInfoContainer.scanInvalid(builder, method.getAnnotation(Invalid.class));
        }
        return builder.build();
    }

    private static AnnoHolder.Builder scanKeys(AnnoHolder.Builder builder, Annotation[][] pAnnotations) {
        int multiIndex = -1;
        String id = "";
        LinkedHashMap<Integer, CacheKey> cacheKeyMap = new LinkedHashMap<Integer, CacheKey>(pAnnotations.length);
        for (int pIndex = 0; pIndex < pAnnotations.length; ++pIndex) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = pAnnotations[pIndex]) {
                if (!(annotation instanceof CacheKey)) continue;
                CacheKey cacheKey = (CacheKey)annotation;
                cacheKeyMap.put(pIndex, cacheKey);
                if (!CacheInfoContainer.isMulti(cacheKey)) continue;
                multiIndex = pIndex;
                id = cacheKey.field();
            }
        }
        return builder.setCacheKeyMap(cacheKeyMap).setMultiIndex(multiIndex).setId(id);
    }

    private static AnnoHolder.Builder scanCached(AnnoHolder.Builder builder, Cached cached) {
        return builder.setCache(cached.value()).setPrefix(cached.prefix()).setExpire(cached.expire());
    }

    private static AnnoHolder.Builder scanCachedGet(AnnoHolder.Builder builder, CachedGet cachedGet) {
        return builder.setCache(cachedGet.value()).setPrefix(cachedGet.prefix()).setExpire(-1);
    }

    private static AnnoHolder.Builder scanInvalid(AnnoHolder.Builder builder, Invalid invalid) {
        return builder.setCache(invalid.value()).setPrefix(invalid.prefix()).setExpire(-1);
    }

    private static MethodHolder getMethodHolder(Method method, AnnoHolder annoHolder) {
        boolean isCollectionReturn = Collection.class.isAssignableFrom(method.getReturnType());
        boolean isMapReturn = Map.class.isAssignableFrom(method.getReturnType());
        CacheInfoContainer.staticAnalyze(method.getParameterTypes(), annoHolder, isCollectionReturn, isMapReturn);
        return new MethodHolder(isCollectionReturn);
    }

    private static void staticAnalyze(Class<?>[] pTypes, AnnoHolder annoHolder, boolean isCollectionReturn, boolean isMapReturn) {
        if (CacheInfoContainer.isInvalidParam(pTypes, annoHolder)) {
            throw new RuntimeException("cache need at least one param key");
        }
        if (CacheInfoContainer.isInvalidMultiCount(annoHolder.getCacheKeyMap())) {
            throw new RuntimeException("only one multi key");
        }
        Map<Integer, CacheKey> cacheKeyMap = annoHolder.getCacheKeyMap();
        for (Map.Entry<Integer, CacheKey> entry : cacheKeyMap.entrySet()) {
            Integer argIndex = entry.getKey();
            CacheKey cacheKey = entry.getValue();
            if (CacheInfoContainer.isMulti(cacheKey) && CacheInfoContainer.isInvalidMulti(pTypes[argIndex])) {
                throw new RuntimeException("multi need a collection instance param");
            }
            if (CacheInfoContainer.isMulti(cacheKey) && CacheInfoContainer.isInvalidResult(isCollectionReturn, cacheKey.field())) {
                throw new RuntimeException("multi cache && collection method return need a result field");
            }
            if (!CacheInfoContainer.isInvalidIdentifier(isMapReturn, isCollectionReturn, cacheKey.field())) continue;
            throw new RuntimeException("id method a collection return method");
        }
    }

    private static boolean isMulti(CacheKey cacheKey) {
        if (null == cacheKey) {
            return false;
        }
        String value = cacheKey.value();
        if (StringKit.isEmpty(value)) {
            return false;
        }
        return value.contains("#i");
    }

    private static boolean isInvalidParam(Class<?>[] pTypes, AnnoHolder annoHolder) {
        Map<Integer, CacheKey> cacheKeyMap = annoHolder.getCacheKeyMap();
        String prefix = annoHolder.getPrefix();
        return (null == pTypes || pTypes.length == 0 || cacheKeyMap.isEmpty()) && StringKit.isEmpty(prefix);
    }

    private static boolean isInvalidMultiCount(Map<Integer, CacheKey> keyMap) {
        int multiCount = 0;
        for (CacheKey cacheKey : keyMap.values()) {
            if (CacheInfoContainer.isMulti(cacheKey) && ++multiCount > 1) break;
        }
        return multiCount > 1;
    }

    private static boolean isInvalidIdentifier(boolean isMapReturn, boolean isCollectionReturn, String field) {
        if (isMapReturn && !StringKit.isEmpty(field)) {
            Logger.warn("@CacheKey's 'field = \"{}\"' is useless.", field);
            return false;
        }
        return !StringKit.isEmpty(field) && !isCollectionReturn;
    }

    private static boolean isInvalidResult(boolean isCollectionReturn, String id) {
        return isCollectionReturn && StringKit.isEmpty(id);
    }

    private static boolean isInvalidMulti(Class<?> paramType) {
        return !Collection.class.isAssignableFrom(paramType) && !paramType.isArray();
    }
}

