/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDesc;
import org.aoju.bus.core.beans.copier.AbstractCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.map.MapWrapper;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class MapToBeanCopier<T>
extends AbstractCopier<Map<?, ?>, T> {
    private final Type targetType;

    public MapToBeanCopier(Map<?, ?> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        Map raw;
        if (source instanceof MapWrapper && (raw = ((MapWrapper)source).getRaw()) instanceof CaseInsensitiveMap) {
            copyOptions.setIgnoreCase(true);
        }
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropertyDesc> targetPropertyDescMap = BeanKit.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            String sKeyStr = this.copyOptions.editFieldName(sKey.toString());
            if (null == sKeyStr) {
                return;
            }
            PropertyDesc tDesc = this.findPropertyDesc(targetPropertyDescMap, sKeyStr);
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            sKeyStr = tDesc.getFieldName();
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), sValue)) {
                return;
            }
            Type fieldType = TypeKit.getActualType(this.targetType, tDesc.getFieldType());
            Object newValue = this.copyOptions.convertField(fieldType, sValue);
            newValue = this.copyOptions.editFieldValue(sKeyStr, newValue);
            tDesc.setValue(this.target, newValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }

    private PropertyDesc findPropertyDesc(Map<String, PropertyDesc> targetPropertyDescMap, String sKeyStr) {
        PropertyDesc PropertyDesc2 = targetPropertyDescMap.get(sKeyStr);
        if (null != PropertyDesc2) {
            return PropertyDesc2;
        }
        PropertyDesc2 = targetPropertyDescMap.get(sKeyStr = StringKit.toCamelCase(sKeyStr));
        if (null != PropertyDesc2) {
            return PropertyDesc2;
        }
        if (sKeyStr.startsWith("is")) {
            sKeyStr = StringKit.removePreAndLowerFirst((CharSequence)sKeyStr, 2);
            PropertyDesc2 = targetPropertyDescMap.get(sKeyStr);
            return PropertyDesc2;
        }
        return null;
    }
}

