/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.bloom;

import org.aoju.bus.core.bloom.BloomFilter;
import org.aoju.bus.core.bloom.filter.DefaultFilter;
import org.aoju.bus.core.bloom.filter.ELFFilter;
import org.aoju.bus.core.bloom.filter.JSFilter;
import org.aoju.bus.core.bloom.filter.PJWFilter;
import org.aoju.bus.core.bloom.filter.SDBMFilter;
import org.aoju.bus.core.toolkit.MathKit;

public class BitMapBloomFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private BloomFilter[] filters;

    public BitMapBloomFilter(int m) {
        long mNum = MathKit.div(String.valueOf(m), String.valueOf(5)).longValue();
        long size = mNum * 1024L * 1024L * 8L;
        this.filters = new BloomFilter[]{new DefaultFilter(size), new ELFFilter(size), new JSFilter(size), new PJWFilter(size), new SDBMFilter(size)};
    }

    public BitMapBloomFilter(int m, BloomFilter ... filters) {
        this(m);
        this.filters = filters;
    }

    @Override
    public boolean add(String text) {
        boolean flag = false;
        for (BloomFilter filter : this.filters) {
            flag |= filter.add(text);
        }
        return flag;
    }

    @Override
    public boolean contains(String text) {
        for (BloomFilter filter : this.filters) {
            if (filter.contains(text)) continue;
            return false;
        }
        return true;
    }
}

