/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.sql.Timestamp;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.instance.Instances;

public class NonClock {
    private final long period;
    private volatile long now;

    private NonClock(long period) {
        this.period = period;
        this.now = System.currentTimeMillis();
        this.scheduleClockUpdating();
    }

    private static NonClock instance() {
        return Instances.singletion(NonClock.class);
    }

    public static long now() {
        return NonClock.instance().currentTimeMillis();
    }

    public static String nowDate() {
        return new Timestamp(NonClock.instance().currentTimeMillis()).toString();
    }

    private void scheduleClockUpdating() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "System Clock");
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> {
            this.now = System.currentTimeMillis();
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    private long currentTimeMillis() {
        return this.now;
    }
}

