/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;

public interface Resource {
    public String getName();

    public URL getUrl();

    public InputStream getStream();

    default public boolean isModified() {
        return false;
    }

    default public BufferedReader getReader(Charset charset) {
        return IoKit.getReader(this.getStream(), charset);
    }

    default public String readString(Charset charset) throws InstrumentException {
        return IoKit.read(this.getReader(charset));
    }

    default public byte[] readBytes() throws InstrumentException {
        return IoKit.readBytes(this.getStream());
    }

    default public void writeTo(OutputStream out) throws InstrumentException {
        try (InputStream in = this.getStream();){
            IoKit.copy(in, out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }
}

