/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.key;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.NetKit;
import org.aoju.bus.core.toolkit.RuntimeKit;

public class HashID {
    public static final long MAX_NUMBER = 0x20000000000000L;
    private static final String DEFAULT_SEPS = "cfhistuCFHISTU";
    private static final String DEFAULT_SALT = "";
    private static final Pattern PATTERN = Pattern.compile("[\\w\\W]{1,12}");
    private static final int DEFAULT_MIN_HASH_LENGTH = 0;
    private static final int MIN_ALPHABET_LENGTH = 16;
    private static final double SEP_DIV = 3.5;
    private static final int GUARD_DIV = 12;
    private final String salt;
    private final int minHashLength;
    private final String alphabet;
    private final String seps;
    private final String guards;

    public HashID() {
        this(DEFAULT_SALT);
    }

    public HashID(String salt) {
        this(salt, 0);
    }

    public HashID(String salt, int minHashLength) {
        this(salt, minHashLength, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    }

    public HashID(String salt, int minHashLength, String alphabet) {
        String guards;
        this.salt = null != salt ? salt : DEFAULT_SALT;
        this.minHashLength = minHashLength > 0 ? minHashLength : 0;
        StringBuilder uniqueAlphabet = new StringBuilder();
        for (int i = 0; i < ((String)alphabet).length(); ++i) {
            if (uniqueAlphabet.indexOf(String.valueOf(((String)alphabet).charAt(i))) != -1) continue;
            uniqueAlphabet.append(((String)alphabet).charAt(i));
        }
        alphabet = uniqueAlphabet.toString();
        if (((String)alphabet).length() < 16) {
            throw new IllegalArgumentException("alphabet must contain at least 16 unique characters");
        }
        if (((String)alphabet).contains(" ")) {
            throw new IllegalArgumentException("alphabet cannot contains spaces");
        }
        Object seps = DEFAULT_SEPS;
        for (int i = 0; i < ((String)seps).length(); ++i) {
            int j = ((String)alphabet).indexOf(((String)seps).charAt(i));
            if (j == -1) {
                seps = ((String)seps).substring(0, i) + " " + ((String)seps).substring(i + 1);
                continue;
            }
            alphabet = ((String)alphabet).substring(0, j) + " " + ((String)alphabet).substring(j + 1);
        }
        alphabet = ((String)alphabet).replaceAll("\\s+", DEFAULT_SALT);
        seps = ((String)seps).replaceAll("\\s+", DEFAULT_SALT);
        if (((String)(seps = HashID.consistentShuffle((String)seps, this.salt))).isEmpty() || (double)((float)((String)alphabet).length() / (float)((String)seps).length()) > 3.5) {
            int seps_len = (int)Math.ceil((double)((String)alphabet).length() / 3.5);
            if (seps_len == 1) {
                ++seps_len;
            }
            if (seps_len > ((String)seps).length()) {
                int diff = seps_len - ((String)seps).length();
                seps = (String)seps + ((String)alphabet).substring(0, diff);
                alphabet = ((String)alphabet).substring(diff);
            } else {
                seps = ((String)seps).substring(0, seps_len);
            }
        }
        alphabet = HashID.consistentShuffle((String)alphabet, this.salt);
        int guardCount = (int)Math.ceil((double)((String)alphabet).length() / 12.0);
        if (((String)alphabet).length() < 3) {
            guards = ((String)seps).substring(0, guardCount);
            seps = ((String)seps).substring(guardCount);
        } else {
            guards = ((String)alphabet).substring(0, guardCount);
            alphabet = ((String)alphabet).substring(guardCount);
        }
        this.guards = guards;
        this.alphabet = alphabet;
        this.seps = seps;
    }

    public static int checkedCast(long value) {
        int result = (int)value;
        if ((long)result != value) {
            throw new IllegalArgumentException("Out of range: " + value);
        }
        return result;
    }

    private static String consistentShuffle(String alphabet, String salt) {
        if (salt.length() <= 0) {
            return alphabet;
        }
        char[] tmpArr = alphabet.toCharArray();
        int i = tmpArr.length - 1;
        int v = 0;
        int p = 0;
        while (i > 0) {
            char asc_val = salt.charAt(v %= salt.length());
            int j = (asc_val + v + (p += asc_val)) % i;
            char tmp = tmpArr[j];
            tmpArr[j] = tmpArr[i];
            tmpArr[i] = tmp;
            --i;
            ++v;
        }
        return new String(tmpArr);
    }

    private static String hash(long input, String alphabet) {
        Object hash = DEFAULT_SALT;
        int alphabetLen = alphabet.length();
        do {
            int index;
            if ((index = (int)(input % (long)alphabetLen)) < 0 || index >= alphabet.length()) continue;
            hash = alphabet.charAt(index) + (String)hash;
        } while ((input /= (long)alphabetLen) > 0L);
        return hash;
    }

    private static Long unhash(String input, String alphabet) {
        long number = 0L;
        for (int i = 0; i < input.length(); ++i) {
            long pos = alphabet.indexOf(input.charAt(i));
            number = number * (long)alphabet.length() + pos;
        }
        return number;
    }

    public static long getDataCenterId(long maxDatacenterId) {
        long id = 1L;
        byte[] mac = NetKit.getLocalHardwareAddress();
        if (null != mac) {
            id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
            id %= maxDatacenterId + 1L;
        }
        return id;
    }

    public static long getWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        try {
            mpid.append(RuntimeKit.getPid());
        }
        catch (InstantiationError instantiationError) {
            // empty catch block
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    public String encode(long ... numbers) {
        if (numbers.length == 0) {
            return DEFAULT_SALT;
        }
        for (long number : numbers) {
            if (number < 0L) {
                return DEFAULT_SALT;
            }
            if (number <= 0x20000000000000L) continue;
            throw new IllegalArgumentException("number can not be greater than 9007199254740992L");
        }
        return this._encode(numbers);
    }

    public long[] decode(String hash) {
        if (hash.isEmpty()) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        String validChars = this.alphabet + this.guards + this.seps;
        for (int i = 0; i < hash.length(); ++i) {
            if (validChars.indexOf(hash.charAt(i)) != -1) continue;
            return Normal.EMPTY_LONG_ARRAY;
        }
        return this._decode(hash, this.alphabet);
    }

    public String encodeHex(String hexa) {
        if (!hexa.matches("^[0-9a-fA-F]+$")) {
            return DEFAULT_SALT;
        }
        ArrayList<Long> matched = new ArrayList<Long>();
        Matcher matcher = PATTERN.matcher(hexa);
        while (matcher.find()) {
            matched.add(Long.parseLong("1" + matcher.group(), 16));
        }
        long[] result = new long[matched.size()];
        for (int i = 0; i < matched.size(); ++i) {
            result[i] = (Long)matched.get(i);
        }
        return this.encode(result);
    }

    public String decodeHex(String hash) {
        long[] numbers;
        StringBuilder result = new StringBuilder();
        for (long number : numbers = this.decode(hash)) {
            result.append(Long.toHexString(number).substring(1));
        }
        return result.toString();
    }

    private String _encode(long ... numbers) {
        long guardIndex;
        char guard;
        long numberHashInt = 0L;
        for (int i = 0; i < numbers.length; ++i) {
            numberHashInt += numbers[i] % (long)(i + 100);
        }
        String alphabet = this.alphabet;
        char ret = alphabet.charAt((int)(numberHashInt % (long)alphabet.length()));
        StringBuilder ret_strB = new StringBuilder(this.minHashLength);
        ret_strB.append(ret);
        for (int i = 0; i < numbers.length; ++i) {
            long num = numbers[i];
            String buffer = ret + this.salt + alphabet;
            alphabet = HashID.consistentShuffle(alphabet, buffer.substring(0, alphabet.length()));
            String last = HashID.hash(num, alphabet);
            ret_strB.append(last);
            if (i + 1 >= numbers.length) continue;
            long sepsIndex = last.length() > 0 ? (long)((int)((num %= (long)(last.charAt(0) + i)) % (long)this.seps.length())) : 0L;
            ret_strB.append(this.seps.charAt((int)sepsIndex));
        }
        Object ret_str = ret_strB.toString();
        if (((String)ret_str).length() < this.minHashLength && ((String)(ret_str = (guard = this.guards.charAt((int)(guardIndex = (numberHashInt + (long)((String)ret_str).charAt(0)) % (long)this.guards.length()))) + (String)ret_str)).length() < this.minHashLength) {
            guardIndex = (numberHashInt + (long)((String)ret_str).charAt(2)) % (long)this.guards.length();
            guard = this.guards.charAt((int)guardIndex);
            ret_str = (String)ret_str + guard;
        }
        int halfLen = alphabet.length() / 2;
        while (((String)ret_str).length() < this.minHashLength) {
            ret_str = (alphabet = HashID.consistentShuffle(alphabet, alphabet)).substring(halfLen) + (String)ret_str + alphabet.substring(0, halfLen);
            int excess = ((String)ret_str).length() - this.minHashLength;
            if (excess <= 0) continue;
            int start_pos = excess / 2;
            ret_str = ((String)ret_str).substring(start_pos, start_pos + this.minHashLength);
        }
        return ret_str;
    }

    private long[] _decode(String hash, String alphabet) {
        ArrayList<Long> ret = new ArrayList<Long>();
        String shuffle = alphabet;
        int i = 0;
        String regexp = "[" + this.guards + "]";
        String hashBreakdown = hash.replaceAll(regexp, " ");
        String[] hashArray = hashBreakdown.split(" ");
        if (hashArray.length == 3 || hashArray.length == 2) {
            i = 1;
        }
        if (hashArray.length > 0 && !(hashBreakdown = hashArray[i]).isEmpty()) {
            char lottery = hashBreakdown.charAt(0);
            hashBreakdown = hashBreakdown.substring(1);
            hashBreakdown = hashBreakdown.replaceAll("[" + this.seps + "]", " ");
            String[] stringArray = hashArray = hashBreakdown.split(" ");
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String aHashArray;
                String subHash = aHashArray = stringArray[j];
                String buffer = lottery + this.salt + shuffle;
                shuffle = HashID.consistentShuffle(shuffle, buffer.substring(0, shuffle.length()));
                ret.add(HashID.unhash(subHash, shuffle));
            }
        }
        long[] arr = new long[ret.size()];
        for (int k = 0; k < arr.length; ++k) {
            arr[k] = (Long)ret.get(k);
        }
        if (!this.encode(arr).equals(hash)) {
            arr = Normal.EMPTY_LONG_ARRAY;
        }
        return arr;
    }

    public String getVersion() {
        return "1.0.0";
    }

    public String getSalt() {
        return this.salt;
    }
}

