/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aoju.bus.core.beans.PathExpression;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.getter.BasicType;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.function.Func0;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.LambdaKit;

public class Dictionary
extends LinkedHashMap<String, Object>
implements BasicType<String> {
    private static final long serialVersionUID = 1L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private boolean caseInsensitive;

    public Dictionary() {
        this(false);
    }

    public Dictionary(boolean caseInsensitive) {
        this(16, caseInsensitive);
    }

    public Dictionary(int initialCapacity) {
        this(initialCapacity, false);
    }

    public Dictionary(Map<String, Object> map) {
        super(null == map ? new HashMap() : map);
    }

    public Dictionary(int initialCapacity, boolean caseInsensitive) {
        this(initialCapacity, 0.75f, caseInsensitive);
    }

    public Dictionary(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, false);
    }

    public Dictionary(int initialCapacity, float loadFactor, boolean caseInsensitive) {
        super(initialCapacity, loadFactor);
        this.caseInsensitive = caseInsensitive;
    }

    public static Dictionary create() {
        return new Dictionary();
    }

    public static <T> Dictionary parse(T bean) {
        return Dictionary.create().parseBean(bean);
    }

    public static Dictionary of(Pair<String, Object> ... pairs) {
        Dictionary dictionary = Dictionary.create();
        for (Pair<String, Object> pair : pairs) {
            dictionary.put(pair.getKey(), pair.getValue());
        }
        return dictionary;
    }

    public static Dictionary of(Object ... keysAndValues) {
        Dictionary dictionary = Dictionary.create();
        String key = null;
        for (int i = 0; i < keysAndValues.length; ++i) {
            if (i % 2 == 0) {
                key = Convert.toString(keysAndValues[i]);
                continue;
            }
            dictionary.put(key, keysAndValues[i]);
        }
        return dictionary;
    }

    @Override
    public Object get(Object key) {
        return super.get(this.customKey((String)key));
    }

    @Override
    public Object put(String key, Object value) {
        return super.put(this.customKey(key), value);
    }

    @Override
    public Dictionary clone() {
        return (Dictionary)super.clone();
    }

    @Override
    public Object getObject(String key) {
        return super.get(key);
    }

    @Override
    public String getString(String attr) {
        return Convert.toString(this.get(attr), null);
    }

    @Override
    public Integer getInt(String attr) {
        return Convert.toInt(this.get(attr), null);
    }

    @Override
    public Long getLong(String attr) {
        return Convert.toLong(this.get(attr), null);
    }

    @Override
    public Float getFloat(String attr) {
        return Convert.toFloat(this.get(attr), null);
    }

    @Override
    public Short getShort(String attr) {
        return Convert.toShort(this.get(attr), null);
    }

    @Override
    public Character getChar(String attr) {
        return Convert.toChar(this.get(attr), null);
    }

    @Override
    public Double getDouble(String attr) {
        return Convert.toDouble(this.get(attr), null);
    }

    @Override
    public Byte getByte(String attr) {
        return Convert.toByte(this.get(attr), null);
    }

    @Override
    public Boolean getBoolean(String attr) {
        return Convert.toBoolean(this.get(attr), null);
    }

    @Override
    public BigDecimal getBigDecimal(String attr) {
        return Convert.toBigDecimal(this.get(attr));
    }

    @Override
    public BigInteger getBigInteger(String attr) {
        return Convert.toBigInteger(this.get(attr));
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return Convert.toEnum(clazz, this.get(key));
    }

    @Override
    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        m.forEach(this::put);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.customKey((String)key));
    }

    @Override
    public Object remove(Object key) {
        return super.remove(this.customKey((String)key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return super.remove(this.customKey((String)key), value);
    }

    @Override
    public boolean replace(String key, Object oldValue, Object newValue) {
        return super.replace(this.customKey(key), oldValue, newValue);
    }

    @Override
    public Object replace(String key, Object value) {
        return super.replace(this.customKey(key), value);
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        return super.getOrDefault(this.customKey((String)key), defaultValue);
    }

    @Override
    public Object computeIfPresent(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return super.computeIfPresent(this.customKey(key), remappingFunction);
    }

    @Override
    public Object compute(String key, BiFunction<? super String, ? super Object, ?> remappingFunction) {
        return super.compute(this.customKey(key), remappingFunction);
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ?> remappingFunction) {
        return super.merge(this.customKey(key), value, remappingFunction);
    }

    @Override
    public Object putIfAbsent(String key, Object value) {
        return super.putIfAbsent(this.customKey(key), value);
    }

    @Override
    public Object computeIfAbsent(String key, Function<? super String, ?> mappingFunction) {
        return super.computeIfAbsent(this.customKey(key), mappingFunction);
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    public <T> T getByPath(String expression) {
        return (T)PathExpression.create(expression).get(this);
    }

    public <T> T getByPath(String expression, Class<T> resultType) {
        return Convert.convert(resultType, this.getByPath(expression));
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanKit.fillBeanWithMap(this, bean, isToCamelCase, false);
        return bean;
    }

    public <T> T toBeanIgnoreCase(T bean) {
        BeanKit.fillBeanWithMapIgnoreCase(this, bean, false);
        return bean;
    }

    public <T> T toBeanWithCamelCase(T bean) {
        BeanKit.fillBeanWithMap(this, bean, true, false);
        return bean;
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanKit.toBeanIgnoreCase(this, clazz, false);
    }

    public <T> Dictionary parseBean(T bean) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanKit.beanToMap(bean));
        return this;
    }

    public <T> Dictionary parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        Assert.notNull(bean, "Bean class must be not null", new Object[0]);
        this.putAll((Map<? extends String, ?>)BeanKit.beanToMap(bean, isToUnderlineCase, ignoreNullValue));
        return this;
    }

    public <T extends Dictionary> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = CollKit.newHashSet(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || null == (value = this.get(entry.getKey())) || !value.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dictionary filter(String ... keys) {
        Dictionary result = new Dictionary(keys.length, 1.0f);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public <T> T getBean(String attr) {
        return this.get(attr, null);
    }

    public Dictionary setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    public Dictionary set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(null != result ? result : defaultValue);
    }

    public Dictionary setFields(Func0<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaKit.getFieldName(f), f.callWithRuntimeException()));
        return this;
    }

    private String customKey(String key) {
        if (this.caseInsensitive && null != key) {
            key = key.toLowerCase();
        }
        return key;
    }
}

