/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.Serializable;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.RandomKit;

public class Weighing<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeMap<Double, T> weightMap = new TreeMap();

    public Weighing() {
    }

    public Weighing(WeightObject<T> weightObj) {
        this();
        if (null != weightObj) {
            this.add(weightObj);
        }
    }

    public Weighing(Iterable<WeightObject<T>> weightObjs) {
        this();
        if (CollKit.isNotEmpty(weightObjs)) {
            for (WeightObject<T> weightObj : weightObjs) {
                this.add(weightObj);
            }
        }
    }

    public Weighing(WeightObject<T>[] weightObjs) {
        this();
        for (WeightObject<T> weightObj : weightObjs) {
            this.add(weightObj);
        }
    }

    public static <T> Weighing<T> create() {
        return new Weighing<T>();
    }

    public Weighing<T> add(T object, double weight) {
        return this.add(new WeightObject<T>(object, weight));
    }

    public Weighing<T> add(WeightObject<T> weightObj) {
        double lastWeight = this.weightMap.size() == 0 ? 0.0 : this.weightMap.lastKey();
        this.weightMap.put(weightObj.getWeight() + lastWeight, weightObj.getObject());
        return this;
    }

    public Weighing<T> clear() {
        if (null != this.weightMap) {
            this.weightMap.clear();
        }
        return this;
    }

    public T next() {
        if (MapKit.isEmpty(this.weightMap)) {
            return null;
        }
        ThreadLocalRandom random = RandomKit.getRandom();
        double randomWeight = this.weightMap.lastKey() * ((Random)random).nextDouble();
        NavigableMap<Double, T> tailMap = this.weightMap.tailMap(randomWeight, false);
        return this.weightMap.get(tailMap.firstKey());
    }

    public static class WeightObject<T> {
        private final double weight;
        private T object;

        public WeightObject(T object, double weight) {
            this.object = object;
            this.weight = weight;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }

        public double getWeight() {
            return this.weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (null == this.object ? 0 : this.object.hashCode());
            long temp = Double.doubleToLongBits(this.weight);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (null == object) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WeightObject other = (WeightObject)object;
            if (null == this.object ? null != other.object : !this.object.equals(other.object)) {
                return false;
            }
            return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
        }
    }
}

