/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.ansi;

import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.ansi.AnsiElement;

public final class Ansi8BitColor
implements AnsiElement {
    private static final String PREFIX_FORE = "38;5;";
    private static final String PREFIX_BACK = "48;5;";
    private final String prefix;
    private final int code;

    private Ansi8BitColor(String prefix, int code) {
        Assert.isTrue(code >= 0 && code <= 255, "Code must be between 0 and 255", new Object[0]);
        this.prefix = prefix;
        this.code = code;
    }

    public static Ansi8BitColor foreground(int code) {
        return new Ansi8BitColor(PREFIX_FORE, code);
    }

    public static Ansi8BitColor background(int code) {
        return new Ansi8BitColor(PREFIX_BACK, code);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Ansi8BitColor other = (Ansi8BitColor)object;
        return this.prefix.equals(other.prefix) && this.code == other.code;
    }

    public int hashCode() {
        return this.prefix.hashCode() * 31 + this.code;
    }

    @Override
    public String toString() {
        return this.prefix + this.code;
    }
}

