/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.aoju.bus.core.collection.TransitionIterator;
import org.aoju.bus.core.map.Table;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.ObjectKit;

public abstract class AbstractTable<R, C, V>
implements Table<R, C, V> {
    private Collection<V> values;
    private Set<Table.Cell<R, C, V>> cellSet;

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Table) {
            Table that = (Table)object;
            return this.cellSet().equals(that.cellSet());
        }
        return false;
    }

    public int hashCode() {
        return this.cellSet().hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    @Override
    public Collection<V> values() {
        Values result = this.values;
        return result == null ? (this.values = new Values()) : result;
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        CellSet result = this.cellSet;
        return result == null ? (this.cellSet = new CellSet()) : result;
    }

    @Override
    public Iterator<Table.Cell<R, C, V>> iterator() {
        return new CellIterator();
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new TransitionIterator<Table.Cell, Object>(AbstractTable.this.cellSet().iterator(), Table.Cell::getValue);
        }

        @Override
        public boolean contains(Object o) {
            return AbstractTable.this.containsValue(o);
        }

        @Override
        public void clear() {
            AbstractTable.this.clear();
        }

        @Override
        public int size() {
            return AbstractTable.this.size();
        }
    }

    private class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public boolean contains(Object o) {
            Table.Cell cell;
            Map row;
            if (o instanceof Table.Cell && null != (row = AbstractTable.this.getRow((cell = (Table.Cell)o).getRowKey()))) {
                return ObjectKit.equals(row.get(cell.getColumnKey()), cell.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                Table.Cell cell = (Table.Cell)o;
                AbstractTable.this.remove(cell.getRowKey(), cell.getColumnKey());
            }
            return false;
        }

        @Override
        public void clear() {
            AbstractTable.this.clear();
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new CellIterator();
        }

        @Override
        public int size() {
            return AbstractTable.this.size();
        }
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        Map.Entry<R, Map<C, V>> rowEntry;
        Iterator<Map.Entry<C, V>> columnIterator;

        private CellIterator() {
            this.rowIterator = AbstractTable.this.rowMap().entrySet().iterator();
            this.columnIterator = IterKit.empty();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        @Override
        public Table.Cell<R, C, V> next() {
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Map.Entry columnEntry = this.columnIterator.next();
            return new SimpleCell(this.rowEntry.getKey(), columnEntry.getKey(), columnEntry.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (this.rowEntry.getValue().isEmpty()) {
                this.rowIterator.remove();
            }
        }
    }

    private static class SimpleCell<R, C, V>
    implements Table.Cell<R, C, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final R rowKey;
        private final C columnKey;
        private final V value;

        SimpleCell(R rowKey, C columnKey, V value) {
            this.rowKey = rowKey;
            this.columnKey = columnKey;
            this.value = value;
        }

        @Override
        public R getRowKey() {
            return this.rowKey;
        }

        @Override
        public C getColumnKey() {
            return this.columnKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Table.Cell) {
                Table.Cell other = (Table.Cell)object;
                return ObjectKit.equal(this.rowKey, other.getRowKey()) && ObjectKit.equal(this.columnKey, other.getColumnKey()) && ObjectKit.equal(this.value, other.getValue());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.rowKey, this.columnKey, this.value);
        }

        public String toString() {
            return "(" + this.rowKey + "," + this.columnKey + ")=" + this.value;
        }
    }
}

