/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

public class HashKit {
    public static int additiveHash(String key, int prime) {
        int hash = key.length();
        for (int i = 0; i < key.length(); ++i) {
            hash += key.charAt(i);
        }
        return hash % prime;
    }

    public static int rotatingHash(String key, int prime) {
        int hash = key.length();
        for (int i = 0; i < key.length(); ++i) {
            hash = hash << 4 ^ hash >> 28 ^ key.charAt(i);
        }
        return hash % prime;
    }

    public static int oneByOneHash(String key) {
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash += key.charAt(i);
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static int bernstein(String key) {
        int hash = 0;
        for (int i = 0; i < key.length(); ++i) {
            hash = 33 * hash + key.charAt(i);
        }
        return hash;
    }

    public static int universal(char[] key, int mask, int[] tab) {
        int hash = key.length;
        int len = key.length;
        for (int i = 0; i < len << 3; i += 8) {
            char k = key[i >> 3];
            if ((k & '\u0001') == 0) {
                hash ^= tab[i + 0];
            }
            if ((k & 2) == 0) {
                hash ^= tab[i + 1];
            }
            if ((k & 4) == 0) {
                hash ^= tab[i + 2];
            }
            if ((k & 8) == 0) {
                hash ^= tab[i + 3];
            }
            if ((k & 0x10) == 0) {
                hash ^= tab[i + 4];
            }
            if ((k & 0x20) == 0) {
                hash ^= tab[i + 5];
            }
            if ((k & 0x40) == 0) {
                hash ^= tab[i + 6];
            }
            if ((k & 0x80) != 0) continue;
            hash ^= tab[i + 7];
        }
        return hash & mask;
    }

    public static int zobrist(char[] key, int mask, int[][] tab) {
        int hash = key.length;
        for (int i = 0; i < key.length; ++i) {
            hash ^= tab[i][key[i]];
        }
        return hash & mask;
    }

    public static int fnvHash(byte[] data) {
        int p = 16777619;
        int hash = -2128831035;
        for (byte b : data) {
            hash = (hash ^ b) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return hash;
    }

    public static int fnvHash(String data) {
        int p = 16777619;
        int hash = -2128831035;
        for (int i = 0; i < data.length(); ++i) {
            hash = (hash ^ data.charAt(i)) * 16777619;
        }
        hash += hash << 13;
        hash ^= hash >> 7;
        hash += hash << 3;
        hash ^= hash >> 17;
        hash += hash << 5;
        return hash;
    }

    public static int intHash(int key) {
        key += ~(key << 15);
        key ^= key >>> 10;
        key += key << 3;
        key ^= key >>> 6;
        key += ~(key << 11);
        key ^= key >>> 16;
        return key;
    }

    public static int rsHash(String text) {
        int b = 378551;
        int a = 63689;
        int hash = 0;
        for (int i = 0; i < text.length(); ++i) {
            hash = hash * a + text.charAt(i);
            a *= b;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int jsHash(String text) {
        int hash = 1315423911;
        for (int i = 0; i < text.length(); ++i) {
            hash ^= (hash << 5) + text.charAt(i) + (hash >> 2);
        }
        return Math.abs(hash) & Integer.MAX_VALUE;
    }

    public static int pjwHash(String text) {
        int bitsInUnsignedInt = 32;
        int threeQuarters = bitsInUnsignedInt * 3 / 4;
        int oneEighth = bitsInUnsignedInt / 8;
        int highBits = -1 << bitsInUnsignedInt - oneEighth;
        int hash = 0;
        int test = 0;
        for (int i = 0; i < text.length(); ++i) {
            test = (hash = (hash << oneEighth) + text.charAt(i)) & highBits;
            if (test == 0) continue;
            hash = (hash ^ test >> threeQuarters) & ~highBits;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int elfHash(String text) {
        int hash = 0;
        int x = 0;
        for (int i = 0; i < text.length(); ++i) {
            x = (int)((long)(hash = (hash << 4) + text.charAt(i)) & 0xF0000000L);
            if (x == 0) continue;
            hash ^= x >> 24;
            hash &= ~x;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int bkdrHash(String text) {
        int seed = 131;
        int hash = 0;
        for (int i = 0; i < text.length(); ++i) {
            hash = hash * seed + text.charAt(i);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int sdbmHash(String text) {
        int hash = 0;
        for (int i = 0; i < text.length(); ++i) {
            hash = text.charAt(i) + (hash << 6) + (hash << 16) - hash;
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int djbHash(String text) {
        int hash = 5381;
        for (int i = 0; i < text.length(); ++i) {
            hash = (hash << 5) + hash + text.charAt(i);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int dekHash(String text) {
        int hash = text.length();
        for (int i = 0; i < text.length(); ++i) {
            hash = hash << 5 ^ hash >> 27 ^ text.charAt(i);
        }
        return hash & Integer.MAX_VALUE;
    }

    public static int apHash(String text) {
        int hash = 0;
        for (int i = 0; i < text.length(); ++i) {
            hash ^= (i & 1) == 0 ? hash << 7 ^ text.charAt(i) ^ hash >> 3 : ~(hash << 11 ^ text.charAt(i) ^ hash >> 5);
        }
        return hash;
    }

    public static long tianlHash(String text) {
        long hash = 0L;
        int iLength = text.length();
        if (iLength == 0) {
            return 0L;
        }
        hash = iLength <= 256 ? 0x1000000L * (long)(iLength - 1) : 0xFF000000L;
        if (iLength <= 96) {
            for (int i = 1; i <= iLength; ++i) {
                char ucChar = text.charAt(i - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (3L * (long)i * (long)ucChar * (long)ucChar + 5L * (long)i * (long)ucChar + 7L * (long)i + (long)(11 * ucChar)) % 0x1000000L;
            }
        } else {
            for (int i = 1; i <= 96; ++i) {
                char ucChar = text.charAt(i + iLength - 96 - 1);
                if (ucChar <= 'Z' && ucChar >= 'A') {
                    ucChar = (char)(ucChar + 32);
                }
                hash += (3L * (long)i * (long)ucChar * (long)ucChar + 5L * (long)i * (long)ucChar + 7L * (long)i + (long)(11 * ucChar)) % 0x1000000L;
            }
        }
        if (hash < 0L) {
            hash *= -1L;
        }
        return hash;
    }

    public static int javaDefaultHash(String text) {
        int h = 0;
        int off = 0;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + text.charAt(off++);
        }
        return h;
    }

    public static long mixHash(String text) {
        long hash = text.hashCode();
        hash <<= 32;
        return hash |= (long)HashKit.fnvHash(text);
    }

    public static long hfHash(String data) {
        int length = data.length();
        long hash = 0L;
        for (int i = 0; i < length; ++i) {
            hash += (long)data.charAt(i) * 3L * (long)i;
        }
        if (hash < 0L) {
            hash = -hash;
        }
        return hash;
    }

    public static long hfIpHash(String data) {
        int length = data.length();
        long hash = 0L;
        for (int i = 0; i < length; ++i) {
            hash += (long)(data.charAt(i % 4) ^ data.charAt(i));
        }
        return hash;
    }
}

