/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import org.aoju.bus.core.lang.function.Func0;
import org.aoju.bus.core.lang.function.Func1;
import org.aoju.bus.core.map.WeakMap;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class LambdaKit {
    private static final WeakMap<String, SerializedLambda> cache = new WeakMap();

    public static <T> SerializedLambda resolve(Func1<T, ?> func) {
        return LambdaKit._resolve(func);
    }

    public static <R> SerializedLambda resolve(Func0<R> func) {
        return LambdaKit._resolve(func);
    }

    public static <P> String getMethodName(Func1<P, ?> func) {
        return LambdaKit.resolve(func).getImplMethodName();
    }

    public static <R> String getMethodName(Func0<R> func) {
        return LambdaKit.resolve(func).getImplMethodName();
    }

    public static <R> Class<R> getRealClass(Func0<?> func) {
        SerializedLambda lambda = LambdaKit.resolve(func);
        LambdaKit.checkLambdaTypeCanGetClass(lambda.getImplMethodKind());
        return ClassKit.loadClass(lambda.getImplClass());
    }

    public static <P, R> Class<P> getRealClass(Func1<P, R> func) {
        SerializedLambda lambda = LambdaKit.resolve(func);
        LambdaKit.checkLambdaTypeCanGetClass(lambda.getImplMethodKind());
        String instantiatedMethodType = lambda.getInstantiatedMethodType();
        return ClassKit.loadClass(StringKit.sub(instantiatedMethodType, 2, StringKit.indexOf(instantiatedMethodType, ';')));
    }

    public static <T> String getFieldName(Func1<T, ?> func) throws IllegalArgumentException {
        return BeanKit.getFieldName(LambdaKit.getMethodName(func));
    }

    public static <T> String getFieldName(Func0<T> func) throws IllegalArgumentException {
        return BeanKit.getFieldName(LambdaKit.getMethodName(func));
    }

    private static void checkLambdaTypeCanGetClass(int implMethodKind) {
        if (implMethodKind != 5 && implMethodKind != 6) {
            throw new IllegalArgumentException("\u8be5lambda\u4e0d\u662f\u5408\u9002\u7684\u65b9\u6cd5\u5f15\u7528");
        }
    }

    private static SerializedLambda _resolve(Serializable func) {
        return cache.computeIfAbsent(func.getClass().getName(), () -> (SerializedLambda)ReflectKit.invoke((Object)func, "writeReplace", new Object[0]));
    }
}

