/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lock.AtomicNoLock;
import org.aoju.bus.core.thread.ExecutorBuilder;
import org.aoju.bus.core.thread.GlobalThread;
import org.aoju.bus.core.thread.NamedThreadFactory;
import org.aoju.bus.core.thread.RejectPolicy;
import org.aoju.bus.core.thread.ThreadBuilder;

public class ThreadKit {
    private static final AtomicNoLock NO_LOCK = new AtomicNoLock();

    public static ExecutorService newExecutor(int corePoolSize) {
        return ExecutorBuilder.create().setCorePoolSize(corePoolSize).build();
    }

    public static ExecutorService newExecutor() {
        return ExecutorBuilder.create().setWorkQueue(new SynchronousQueue<Runnable>()).build();
    }

    public static ThreadPoolExecutor newExecutor(int corePoolSize, int maximumPoolSize) {
        return ExecutorBuilder.create().setCorePoolSize(corePoolSize).setMaxPoolSize(maximumPoolSize).build();
    }

    public static ExecutorService newExecutor(int corePoolSize, int maximumPoolSize, int maximumQueueSize) {
        return ExecutorBuilder.create().setCorePoolSize(corePoolSize).setMaxPoolSize(maximumPoolSize).setWorkQueue(new LinkedBlockingQueue<Runnable>(maximumQueueSize)).build();
    }

    public static ExecutorService newSingleExecutor() {
        return ExecutorBuilder.create().setCorePoolSize(1).setMaxPoolSize(1).setKeepAliveTime(0L).buildFinalizable();
    }

    public static ThreadPoolExecutor newExecutorByBlockingCoefficient(float blockingCoefficient) {
        if (blockingCoefficient >= 1.0f || blockingCoefficient < 0.0f) {
            throw new IllegalArgumentException("[blockingCoefficient] must between 0 and 1, or equals 0.");
        }
        int poolSize = (int)((float)Runtime.getRuntime().availableProcessors() / (1.0f - blockingCoefficient));
        return ExecutorBuilder.create().setCorePoolSize(poolSize).setMaxPoolSize(poolSize).setKeepAliveTime(0L).build();
    }

    public static ExecutorService newFixedExecutor(int nThreads, String threadNamePrefix, boolean isBlocked) {
        return ThreadKit.newFixedExecutor(nThreads, 1024, threadNamePrefix, isBlocked);
    }

    public static ExecutorService newFixedExecutor(int nThreads, int maximumQueueSize, String threadNamePrefix, boolean isBlocked) {
        return ThreadKit.newFixedExecutor(nThreads, maximumQueueSize, threadNamePrefix, (isBlocked ? RejectPolicy.BLOCK : RejectPolicy.ABORT).getValue());
    }

    public static ExecutorService newFixedExecutor(int nThreads, int maximumQueueSize, String threadNamePrefix, RejectedExecutionHandler handler) {
        return ExecutorBuilder.create().setCorePoolSize(nThreads).setMaxPoolSize(nThreads).setWorkQueue(new LinkedBlockingQueue<Runnable>(maximumQueueSize)).setThreadFactory(ThreadKit.createThreadFactory(threadNamePrefix)).setHandler(handler).build();
    }

    public static void execute(Runnable runnable) {
        GlobalThread.execute(runnable);
    }

    public static Runnable excAsync(Runnable runnable, boolean isDaemon) {
        Thread thread = new Thread(() -> runnable.run());
        thread.setDaemon(isDaemon);
        thread.start();
        return runnable;
    }

    public static <T> Future<T> execAsync(Callable<T> task) {
        return GlobalThread.submit(task);
    }

    public static Future<?> execAsync(Runnable runnable) {
        return GlobalThread.submit(runnable);
    }

    public static Runnable execAsync(Runnable runnable, boolean isDaemon) {
        Thread thread = new Thread(runnable);
        thread.setDaemon(isDaemon);
        thread.start();
        return runnable;
    }

    public static <T> CompletionService<T> newCompletionService() {
        return new ExecutorCompletionService(GlobalThread.getExecutor());
    }

    public static <T> CompletionService<T> newCompletionService(ExecutorService executor) {
        return new ExecutorCompletionService(executor);
    }

    public static CountDownLatch newCountDownLatch(int threadCount) {
        return new CountDownLatch(threadCount);
    }

    public static Thread newThread(Runnable runnable, String name) {
        Thread t = ThreadKit.newThread(runnable, name, false);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    public static Thread newThread(Runnable runnable, String name, boolean isDaemon) {
        Thread t = new Thread(null, runnable, name);
        t.setDaemon(isDaemon);
        return t;
    }

    public static boolean sleep(Number timeout, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(timeout.longValue());
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean sleep(Number millis) {
        if (null == millis) {
            return true;
        }
        return ThreadKit.sleep(millis.longValue());
    }

    public static boolean sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    public static boolean safeSleep(Number millis) {
        if (null == millis) {
            return true;
        }
        return ThreadKit.safeSleep(millis.longValue());
    }

    public static boolean safeSleep(long millis) {
        long spendTime;
        for (long done = 0L; done >= 0L && done < millis; done += spendTime) {
            long before = System.currentTimeMillis();
            if (!ThreadKit.sleep(millis - done)) {
                return false;
            }
            spendTime = System.currentTimeMillis() - before;
            if (spendTime <= 0L) break;
        }
        return true;
    }

    public static StackTraceElement[] getStackTrace() {
        return Thread.currentThread().getStackTrace();
    }

    public static StackTraceElement getStackTraceElement(int i) {
        StackTraceElement[] stackTrace = ThreadKit.getStackTrace();
        if (i < 0) {
            i += stackTrace.length;
        }
        return stackTrace[i];
    }

    public static <T> ThreadLocal<T> createThreadLocal(boolean isInheritable) {
        if (isInheritable) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    }

    public static <T> ThreadLocal<T> createThreadLocal(Supplier<? extends T> supplier) {
        return ThreadLocal.withInitial(supplier);
    }

    public static ThreadBuilder createThreadFactoryBuilder() {
        return ThreadBuilder.create();
    }

    public static ThreadFactory createThreadFactory(String threadNamePrefix) {
        return ThreadBuilder.create().setNamePrefix(threadNamePrefix).build();
    }

    public static void interrupt(Thread thread, boolean isJoin) {
        if (null != thread && !thread.isInterrupted()) {
            thread.interrupt();
            if (isJoin) {
                ThreadKit.waitFor(thread);
            }
        }
    }

    public static void waitFor() {
        ThreadKit.waitFor(Thread.currentThread());
    }

    public static void waitFor(Thread thread) {
        boolean dead = false;
        do {
            try {
                thread.join();
                dead = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!dead);
    }

    public static Thread[] getThreads() {
        return ThreadKit.getThreads(Thread.currentThread().getThreadGroup().getParent());
    }

    public static Thread[] getThreads(ThreadGroup group) {
        Thread[] slackList = new Thread[group.activeCount() * 2];
        int actualSize = group.enumerate(slackList);
        Thread[] result = new Thread[actualSize];
        System.arraycopy(slackList, 0, result, 0, actualSize);
        return result;
    }

    public static Thread getMainThread() {
        for (Thread thread : ThreadKit.getThreads()) {
            if (thread.getId() != 1L) continue;
            return thread;
        }
        return null;
    }

    public static ThreadFactory newNamedThreadFactory(String prefix, boolean isDaemon) {
        return new NamedThreadFactory(prefix, isDaemon);
    }

    public static ThreadFactory newNamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon) {
        return new NamedThreadFactory(prefix, threadGroup, isDaemon);
    }

    public static ThreadFactory newNamedThreadFactory(String prefix, ThreadGroup threadGroup, boolean isDaemon, Thread.UncaughtExceptionHandler handler) {
        return new NamedThreadFactory(prefix, threadGroup, isDaemon, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sync(Object object) {
        Object object2 = object;
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException e) {
                Console.error(e.getMessage());
            }
        }
    }

    public static ScheduledThreadPoolExecutor createScheduledExecutor(int corePoolSize) {
        return new ScheduledThreadPoolExecutor(corePoolSize);
    }

    public static ScheduledThreadPoolExecutor schedule(ScheduledThreadPoolExecutor executor, Runnable command, long initialDelay, long period, boolean fixedRateOrFixedDelay) {
        return ThreadKit.schedule(executor, command, initialDelay, period, TimeUnit.MILLISECONDS, fixedRateOrFixedDelay);
    }

    public static ScheduledThreadPoolExecutor schedule(ScheduledThreadPoolExecutor executor, Runnable command, long initialDelay, long period, TimeUnit timeUnit, boolean fixedRateOrFixedDelay) {
        if (null == executor) {
            executor = ThreadKit.createScheduledExecutor(2);
        }
        if (fixedRateOrFixedDelay) {
            executor.scheduleAtFixedRate(command, initialDelay, period, timeUnit);
        } else {
            executor.scheduleWithFixedDelay(command, initialDelay, period, timeUnit);
        }
        return executor;
    }

    public static StampedLock createStampLock() {
        return new StampedLock();
    }

    public static ReentrantReadWriteLock createReadWriteLock(boolean fair) {
        return new ReentrantReadWriteLock(fair);
    }

    public static AtomicNoLock getNoLock() {
        return NO_LOCK;
    }

    public static final class FastBufferThread
    extends Thread {
        private int pageIndex;

        public FastBufferThread(Runnable target, String name) {
            super(target, name);
        }

        public int getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(int pageIndex) {
            this.pageIndex = pageIndex;
        }
    }
}

