/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern;

import org.aoju.bus.core.builder.Builder;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.text.TextJoiner;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.cron.pattern.Part;

public class CronBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    final String[] parts = new String[7];

    public static CronBuilder of() {
        return new CronBuilder();
    }

    public CronBuilder setValues(Part part, int ... values) {
        for (int value : values) {
            part.checkValue(value);
        }
        return this.set(part, ArrayKit.join(",", new Object[]{values}));
    }

    public CronBuilder setRange(Part part, int begin, int end) {
        Assert.notNull(part);
        part.checkValue(begin);
        part.checkValue(end);
        return this.set(part, StringKit.format((CharSequence)"{}-{}", begin, end));
    }

    public CronBuilder set(Part part, String value) {
        this.parts[part.ordinal()] = value;
        return this;
    }

    @Override
    public String build() {
        for (int i = Part.MINUTE.ordinal(); i < Part.YEAR.ordinal(); ++i) {
            if (!StringKit.isBlank(this.parts[i])) continue;
            this.parts[i] = "*";
        }
        return TextJoiner.of(" ").setNullMode(TextJoiner.NullMode.IGNORE).append((T[])this.parts).toString();
    }
}

