/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cron.pattern;

import org.aoju.bus.core.exception.CrontabException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Fields;

public enum Part {
    SECOND(13, 0, 59),
    MINUTE(12, 0, 59),
    HOUR(11, 0, 23),
    DAY_OF_MONTH(5, 1, 31),
    MONTH(2, Fields.Month.Jan.getKey(), Fields.Month.Dec.getKey()),
    DAY_OF_WEEK(7, Fields.Week.Sun.getKey(), Fields.Week.Sat.getKey()),
    YEAR(1, 1970, 2099);

    private static final Part[] ENUMS;
    private final int calendarField;
    private final int min;
    private final int max;

    private Part(int calendarField, int min, int max) {
        this.calendarField = calendarField;
        if (min > max) {
            this.min = max;
            this.max = min;
        } else {
            this.min = min;
            this.max = max;
        }
    }

    public static Part of(int i) {
        return ENUMS[i];
    }

    public int getCalendarField() {
        return this.calendarField;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int checkValue(int value) throws CrontabException {
        Assert.checkBetween(value, this.min, this.max, () -> new CrontabException("Value {} out of range: [{} , {}]", value, this.min, this.max));
        return value;
    }

    static {
        ENUMS = Part.values();
    }
}

