/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.drivers.proc;

import java.io.File;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.linux.ProcPath;

@ThreadSafe
public final class ProcessStat {
    public static final int PROC_PID_STAT_LENGTH;
    private static final Pattern SOCKET;

    public static Triple<String, Character, Map<PidStat, Long>> getPidStats(int pid) {
        String stat = Builder.getStringFromFile(String.format(ProcPath.PID_STAT, pid));
        if (stat.isEmpty()) {
            return null;
        }
        int nameStart = stat.indexOf(40) + 1;
        int nameEnd = stat.indexOf(41);
        String name = stat.substring(nameStart, nameEnd);
        Character state = Character.valueOf(stat.charAt(nameEnd + 2));
        String[] split = RegEx.SPACES.split(stat.substring(nameEnd + 4).trim());
        EnumMap<PidStat, Long> statMap = new EnumMap<PidStat, Long>(PidStat.class);
        PidStat[] enumArray = (PidStat[])PidStat.class.getEnumConstants();
        for (int i = 3; i < enumArray.length && i - 3 < split.length; ++i) {
            statMap.put(enumArray[i], Builder.parseLongOrDefault(split[i - 3], 0L));
        }
        return Triple.of(name, state, statMap);
    }

    public static Map<PidStatM, Long> getPidStatM(int pid) {
        String statm = Builder.getStringFromFile(String.format(ProcPath.PID_STATM, pid));
        if (statm.isEmpty()) {
            return null;
        }
        String[] split = RegEx.SPACES.split(statm);
        EnumMap<PidStatM, Long> statmMap = new EnumMap<PidStatM, Long>(PidStatM.class);
        PidStatM[] enumArray = (PidStatM[])PidStatM.class.getEnumConstants();
        for (int i = 0; i < enumArray.length && i < split.length; ++i) {
            statmMap.put(enumArray[i], Builder.parseLongOrDefault(split[i], 0L));
        }
        return statmMap;
    }

    public static File[] getFileDescriptorFiles(int pid) {
        return ProcessStat.listNumericFiles(String.format(ProcPath.PID_FD, pid));
    }

    public static File[] getPidFiles() {
        return ProcessStat.listNumericFiles(ProcPath.PROC);
    }

    public static Map<Integer, Integer> querySocketToPidMap() {
        HashMap<Integer, Integer> pidMap = new HashMap<Integer, Integer>();
        for (File f : ProcessStat.getPidFiles()) {
            File[] fds;
            int pid = Builder.parseIntOrDefault(f.getName(), -1);
            for (File fd : fds = ProcessStat.getFileDescriptorFiles(pid)) {
                Matcher m;
                String symLink = Builder.readSymlinkTarget(fd);
                if (symLink == null || !(m = SOCKET.matcher(symLink)).matches()) continue;
                pidMap.put(Builder.parseIntOrDefault(m.group(1), -1), pid);
            }
        }
        return pidMap;
    }

    public static List<Integer> getThreadIds(int pid) {
        File[] threads = ProcessStat.listNumericFiles(String.format(ProcPath.TASK_PATH, pid));
        return Arrays.stream(threads).map(thread -> Builder.parseIntOrDefault(thread.getName(), 0)).filter(threadId -> threadId != pid).collect(Collectors.toList());
    }

    private static File[] listNumericFiles(String path) {
        File directory = new File(path);
        File[] numericFiles = directory.listFiles(file -> RegEx.NUMBERS.matcher(file.getName()).matches());
        return numericFiles == null ? new File[]{} : numericFiles;
    }

    public static OSProcess.State getState(char stateValue) {
        return switch (stateValue) {
            case 'R' -> OSProcess.State.RUNNING;
            case 'S' -> OSProcess.State.SLEEPING;
            case 'D' -> OSProcess.State.WAITING;
            case 'Z' -> OSProcess.State.ZOMBIE;
            case 'T' -> OSProcess.State.STOPPED;
            default -> OSProcess.State.OTHER;
        };
    }

    static {
        SOCKET = Pattern.compile("socket:\\[(\\d+)\\]");
        String stat = Builder.getStringFromFile(ProcPath.SELF_STAT);
        PROC_PID_STAT_LENGTH = stat.contains(")") ? Builder.countStringToLongArray(stat, ' ') + 3 : 52;
    }

    public static enum PidStat {
        PID,
        COMM,
        STATE,
        PPID,
        PGRP,
        SESSION,
        TTY_NR,
        PTGID,
        FLAGS,
        MINFLT,
        CMINFLT,
        MAJFLT,
        CMAJFLT,
        UTIME,
        STIME,
        CUTIME,
        CSTIME,
        PRIORITY,
        NICE,
        NUM_THREADS,
        ITREALVALUE,
        STARTTIME,
        VSIZE,
        RSS,
        RSSLIM,
        STARTCODE,
        ENDCODE,
        STARTSTACK,
        KSTKESP,
        KSTKEIP,
        SIGNAL,
        BLOCKED,
        SIGIGNORE,
        SIGCATCH,
        WCHAN,
        NSWAP,
        CNSWAP,
        EXIT_SIGNAL,
        PROCESSOR,
        RT_PRIORITY,
        POLICY,
        DELAYACCT_BLKIO_TICKS,
        GUEST_TIME,
        CGUEST_TIME,
        START_DATA,
        END_DATA,
        START_BRK,
        ARG_START,
        ARG_END,
        ENV_START,
        ENV_END,
        EXIT_CODE;

    }

    public static enum PidStatM {
        SIZE,
        RESIDENT,
        SHARED,
        TEXT,
        LIB,
        DATA,
        DT;

    }
}

