/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.builtin.hardware.VirtualMemory;
import org.aoju.bus.health.unix.freebsd.BsdSysctlKit;
import org.aoju.bus.health.unix.freebsd.hardware.FreeBsdVirtualMemory;

@ThreadSafe
final class FreeBsdGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Long> total = Memoize.memoize(FreeBsdGlobalMemory::queryPhysMem);
    private final Supplier<Long> pageSize = Memoize.memoize(FreeBsdGlobalMemory::queryPageSize);
    private final Supplier<Long> available = Memoize.memoize(this::queryVmStats, Memoize.defaultExpiration());
    private final Supplier<VirtualMemory> vm = Memoize.memoize(this::createVirtualMemory);

    FreeBsdGlobalMemory() {
    }

    private static long queryPhysMem() {
        return BsdSysctlKit.sysctl("hw.physmem", 0L);
    }

    private static long queryPageSize() {
        return Builder.parseLongOrDefault(Executor.getFirstAnswer("sysconf PAGESIZE"), 4096L);
    }

    @Override
    public long getAvailable() {
        return this.available.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private long queryVmStats() {
        int inactive = BsdSysctlKit.sysctl("vm.stats.vm.v_inactive_count", 0);
        int free = BsdSysctlKit.sysctl("vm.stats.vm.v_free_count", 0);
        return (long)(inactive + free) * this.getPageSize();
    }

    private VirtualMemory createVirtualMemory() {
        return new FreeBsdVirtualMemory(this);
    }
}

