/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.NewCall;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.plugin.httpv.Cancelable;
import org.aoju.bus.http.plugin.httpv.Convertor;
import org.aoju.bus.http.plugin.httpv.CoverCall;
import org.aoju.bus.http.plugin.httpv.CoverHttp;
import org.aoju.bus.http.plugin.httpv.CoverResult;
import org.aoju.bus.http.plugin.httpv.CoverTasks;
import org.aoju.bus.http.plugin.httpv.Downloads;
import org.aoju.bus.http.plugin.httpv.Preprocessor;
import org.aoju.bus.http.socket.WebSocket;
import org.aoju.bus.http.socket.WebSocketListener;

public class Httpv {
    Httpd httpd;
    String baseUrl;
    Map<String, String> mediaTypes;
    CoverTasks.Executor executor;
    Preprocessor[] preprocessors;
    List<TagTask> tagTasks;
    int preprocTimeoutTimes;
    Charset charset;
    String bodyType;

    public Httpv() {
    }

    public Httpv(Builder builder) {
        this.httpd = builder.httpd();
        this.baseUrl = builder.baseUrl();
        this.mediaTypes = builder.getMediaTypes();
        this.executor = new CoverTasks.Executor(this.httpd.dispatcher().executorService(), builder.mainExecutor(), builder.downloadListener(), builder.responseListener(), builder.exceptionListener(), builder.completeListener(), builder.msgConvertors());
        this.preprocessors = builder.preprocessors();
        this.preprocTimeoutTimes = builder.preprocTimeoutTimes();
        this.charset = builder.charset();
        this.bodyType = builder.bodyType();
        this.tagTasks = new LinkedList<TagTask>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public CoverHttp.Async async(String url) {
        return new CoverHttp.Async(this, this.urlPath(url, false));
    }

    public CoverHttp.Sync sync(String url) {
        return new CoverHttp.Sync(this, this.urlPath(url, false));
    }

    public CoverCall.Client webSocket(String url) {
        return new CoverCall.Client(this, this.urlPath(url, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancel(String tag) {
        if (null == tag) {
            return 0;
        }
        int count = 0;
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            Iterator<TagTask> it = this.tagTasks.iterator();
            while (it.hasNext()) {
                TagTask tagCall = it.next();
                if (tagCall.tag.contains(tag)) {
                    if (tagCall.canceler.cancel()) {
                        ++count;
                    }
                    it.remove();
                    continue;
                }
                if (!tagCall.isExpired()) continue;
                it.remove();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        this.httpd.dispatcher().cancelAll();
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            this.tagTasks.clear();
        }
    }

    public NewCall request(Request request) {
        return this.httpd.newCall(request);
    }

    public WebSocket webSocket(Request request, WebSocketListener listener) {
        return this.httpd.newWebSocket(request, listener);
    }

    public Httpd httpd() {
        return this.httpd;
    }

    public int preprocTimeoutMillis() {
        return this.preprocTimeoutTimes * (this.httpd.connectTimeoutMillis() + this.httpd.writeTimeoutMillis() + this.httpd.readTimeoutMillis());
    }

    public int getTagTaskCount() {
        return this.tagTasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagTask addTagTask(String tag, Cancelable canceler, CoverHttp<?> task) {
        TagTask tagTask = new TagTask(tag, canceler, task);
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            this.tagTasks.add(tagTask);
        }
        return tagTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTagTask(CoverHttp<?> task) {
        List<TagTask> list = this.tagTasks;
        synchronized (list) {
            Iterator<TagTask> it = this.tagTasks.iterator();
            while (it.hasNext()) {
                TagTask tagCall = it.next();
                if (tagCall.task == task) {
                    it.remove();
                    break;
                }
                if (!tagCall.isExpired()) continue;
                it.remove();
            }
        }
    }

    public MediaType mediaType(String type) {
        String mediaType = this.mediaTypes.get(type);
        if (null != mediaType) {
            return MediaType.valueOf(mediaType);
        }
        return MediaType.valueOf("application/octet-stream");
    }

    public CoverTasks.Executor executor() {
        return this.executor;
    }

    public void preprocess(CoverHttp<? extends CoverHttp<?>> coverHttp, Runnable request, boolean skipPreproc, boolean skipSerialPreproc) {
        int index;
        if (this.preprocessors.length == 0 || skipPreproc) {
            request.run();
            return;
        }
        if (skipSerialPreproc) {
            for (index = 0; index < this.preprocessors.length && this.preprocessors[index] instanceof SerialPreprocessor; ++index) {
            }
        }
        if (index < this.preprocessors.length) {
            RealPreChain chain = new RealPreChain(this.preprocessors, coverHttp, request, index + 1, skipSerialPreproc);
            this.preprocessors[index].doProcess(chain);
        } else {
            request.run();
        }
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String urlPath(String urlPath, boolean websocket) {
        Object fullUrl;
        if (null == urlPath) {
            if (null == this.baseUrl) throw new InstrumentException("Before setting BaseUrl, you must specify a specific path to initiate a request!");
            fullUrl = this.baseUrl;
        } else {
            boolean isFullPath;
            boolean bl = isFullPath = urlPath.startsWith("https://") || urlPath.startsWith("http://") || urlPath.startsWith("wss://") || urlPath.startsWith("ws://");
            if (isFullPath) {
                fullUrl = urlPath;
            } else {
                if (null == this.baseUrl) throw new InstrumentException("Before setting BaseUrl, you must use the full path URL to initiate the request. The current URL is\uff1a" + urlPath);
                fullUrl = this.baseUrl + urlPath;
            }
        }
        if (websocket && ((String)fullUrl).startsWith("http")) {
            return ((String)fullUrl).replaceFirst("http", "ws");
        }
        if (websocket || !((String)fullUrl).startsWith("ws")) return fullUrl;
        return ((String)fullUrl).replaceFirst("ws", "http");
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public Map<String, String> mediaTypes() {
        return this.mediaTypes;
    }

    public Preprocessor[] preprocessors() {
        return this.preprocessors;
    }

    public List<TagTask> tagTasks() {
        return this.tagTasks;
    }

    public int preprocTimeoutTimes() {
        return this.preprocTimeoutTimes;
    }

    public Charset charset() {
        return this.charset;
    }

    public String bodyType() {
        return this.bodyType;
    }

    public static class Builder {
        private Httpd httpd;
        private String baseUrl;
        private Map<String, String> mediaTypes;
        private HttpvConfig config;
        private Executor mainExecutor;
        private List<Preprocessor> preprocessors;
        private Downloads.Listener downloadListener;
        private CoverTasks.Listener<CoverResult> responseListener;
        private CoverTasks.Listener<IOException> exceptionListener;
        private CoverTasks.Listener<CoverResult.State> completeListener;
        private List<Convertor> convertors;
        private int preprocTimeoutTimes = 10;
        private Charset charset = org.aoju.bus.core.lang.Charset.UTF_8;
        private String bodyType = "form";

        public Builder() {
            this.mediaTypes = new HashMap<String, String>();
            this.mediaTypes.put("*", "application/octet-stream");
            this.mediaTypes.put("png", "image/png");
            this.mediaTypes.put("jpg", "image/jpeg");
            this.mediaTypes.put("jpeg", "image/jpeg");
            this.mediaTypes.put("wav", "audio/wav");
            this.mediaTypes.put("mp3", "audio/mp3");
            this.mediaTypes.put("mp4", "video/mpeg4");
            this.mediaTypes.put("txt", "text/plain");
            this.mediaTypes.put("xls", "application/x-xls");
            this.mediaTypes.put("xml", "text/xml");
            this.mediaTypes.put("apk", "application/vnd.android.package-archive");
            this.mediaTypes.put("doc", "application/msword");
            this.mediaTypes.put("pdf", "application/pdf");
            this.mediaTypes.put("html", "text/html");
            this.preprocessors = new ArrayList<Preprocessor>();
            this.convertors = new ArrayList<Convertor>();
        }

        public Builder(Httpv httpv) {
            this.httpd = httpv.httpd();
            this.baseUrl = httpv.baseUrl();
            this.mediaTypes = httpv.mediaTypes();
            this.preprocessors = new ArrayList<Preprocessor>();
            Collections.addAll(this.preprocessors, httpv.preprocessors());
            CoverTasks.Executor executor = httpv.executor();
            this.downloadListener = executor.getDownloadListener();
            this.responseListener = executor.getResponseListener();
            this.exceptionListener = executor.getExceptionListener();
            this.completeListener = executor.getCompleteListener();
            this.convertors = new ArrayList<Convertor>();
            Collections.addAll(this.convertors, executor.getConvertors());
            this.preprocTimeoutTimes = httpv.preprocTimeoutTimes();
            this.charset = httpv.charset();
            this.bodyType = httpv.bodyType();
        }

        private static void addCopyInterceptor(Httpd.Builder builder) {
            builder.addInterceptor(chain -> {
                Request request = chain.request();
                Response response = chain.proceed(request);
                ResponseBody body = response.body();
                String type = response.header("Content-Type");
                if (null == body || null != type && (type.contains("octet-stream") || type.contains("image") || type.contains("video") || type.contains("archive") || type.contains("word") || type.contains("xls") || type.contains("pdf"))) {
                    return response;
                }
                ResponseBody newBody = ResponseBody.create(body.contentType(), body.bytes());
                return response.newBuilder().body(newBody).build();
            });
        }

        private static int androidSdkInt() {
            try {
                Class<?> versionClass = Class.forName("android.os.Build$VERSION");
                Field field = versionClass.getDeclaredField("SDK_INT");
                return field.getInt(field);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
                return 0;
            }
        }

        public Builder config(HttpvConfig config) {
            this.config = config;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder mediaTypes(Map<String, String> mediaTypes) {
            if (null != mediaTypes) {
                this.mediaTypes.putAll(mediaTypes);
            }
            return this;
        }

        public Builder mediaTypes(String key, String value) {
            if (null != key && null != value) {
                this.mediaTypes.put(key, value);
            }
            return this;
        }

        public Builder callbackExecutor(Executor executor) {
            this.mainExecutor = executor;
            return this;
        }

        public Builder addPreprocessor(Preprocessor preprocessor) {
            if (null != preprocessor) {
                this.preprocessors.add(preprocessor);
            }
            return this;
        }

        public Builder addSerialPreprocessor(Preprocessor preprocessor) {
            if (null != preprocessor) {
                this.preprocessors.add(new SerialPreprocessor(preprocessor));
            }
            return this;
        }

        public Builder preprocTimeoutTimes(int times) {
            if (times > 0) {
                this.preprocTimeoutTimes = times;
            }
            return this;
        }

        public Builder responseListener(CoverTasks.Listener<CoverResult> listener) {
            this.responseListener = listener;
            return this;
        }

        public Builder exceptionListener(CoverTasks.Listener<IOException> listener) {
            this.exceptionListener = listener;
            return this;
        }

        public Builder completeListener(CoverTasks.Listener<CoverResult.State> listener) {
            this.completeListener = listener;
            return this;
        }

        public Builder downloadListener(Downloads.Listener listener) {
            this.downloadListener = listener;
            return this;
        }

        public Builder addMsgConvertor(Convertor convertor) {
            if (null != convertor) {
                this.convertors.add(convertor);
            }
            return this;
        }

        public Builder charset(Charset charset) {
            if (null != charset) {
                this.charset = charset;
            }
            return this;
        }

        public Builder bodyType(String bodyType) {
            if (null != bodyType) {
                this.bodyType = bodyType;
            }
            return this;
        }

        public Httpv build() {
            if (null != this.config || null == this.httpd) {
                Httpd.Builder builder = new Httpd.Builder();
                if (null != this.config) {
                    this.config.config(builder);
                }
                if (null != this.mainExecutor && Builder.androidSdkInt() > 24) {
                    Builder.addCopyInterceptor(builder);
                }
                this.httpd = builder.build();
            }
            return new Httpv(this);
        }

        public Httpd httpd() {
            return this.httpd;
        }

        public String baseUrl() {
            return this.baseUrl;
        }

        public Map<String, String> getMediaTypes() {
            return this.mediaTypes;
        }

        public Executor mainExecutor() {
            return this.mainExecutor;
        }

        public Preprocessor[] preprocessors() {
            return this.preprocessors.toArray(new Preprocessor[0]);
        }

        public Downloads.Listener downloadListener() {
            return this.downloadListener;
        }

        public CoverTasks.Listener<CoverResult> responseListener() {
            return this.responseListener;
        }

        public CoverTasks.Listener<IOException> exceptionListener() {
            return this.exceptionListener;
        }

        public CoverTasks.Listener<CoverResult.State> completeListener() {
            return this.completeListener;
        }

        public Convertor[] msgConvertors() {
            return this.convertors.toArray(new Convertor[0]);
        }

        public int preprocTimeoutTimes() {
            return this.preprocTimeoutTimes;
        }

        public Charset charset() {
            return this.charset;
        }

        public String bodyType() {
            return this.bodyType;
        }
    }

    public class TagTask {
        String tag;
        Cancelable canceler;
        CoverHttp<?> task;
        long createAt;

        TagTask(String tag, Cancelable canceler, CoverHttp<?> task) {
            this.tag = tag;
            this.canceler = canceler;
            this.task = task;
            this.createAt = System.nanoTime();
        }

        boolean isExpired() {
            return System.nanoTime() - this.createAt > (long)(1000000 * Httpv.this.preprocTimeoutMillis());
        }

        public void setTag(String tag) {
            this.tag = tag;
        }
    }

    public static class SerialPreprocessor
    implements Preprocessor {
        private Preprocessor preprocessor;
        private Queue<Preprocessor.PreChain> pendings;
        private boolean running = false;

        public SerialPreprocessor(Preprocessor preprocessor) {
            this.preprocessor = preprocessor;
            this.pendings = new LinkedList<Preprocessor.PreChain>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doProcess(Preprocessor.PreChain chain) {
            boolean should = true;
            SerialPreprocessor serialPreprocessor = this;
            synchronized (serialPreprocessor) {
                if (this.running) {
                    this.pendings.add(chain);
                    should = false;
                } else {
                    this.running = true;
                }
            }
            if (should) {
                this.preprocessor.doProcess(chain);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterProcess() {
            Preprocessor.PreChain chain = null;
            SerialPreprocessor serialPreprocessor = this;
            synchronized (serialPreprocessor) {
                if (this.pendings.size() > 0) {
                    chain = this.pendings.poll();
                } else {
                    this.running = false;
                }
            }
            if (null != chain) {
                this.preprocessor.doProcess(chain);
            }
        }
    }

    class RealPreChain
    implements Preprocessor.PreChain {
        private int index;
        private Preprocessor[] preprocessors;
        private CoverHttp<?> coverHttp;
        private Runnable request;
        private boolean noSerialPreprocess;

        public RealPreChain(Preprocessor[] preprocessors, CoverHttp<?> coverHttp, Runnable request, int index, boolean noSerialPreprocess) {
            this.index = index;
            this.preprocessors = preprocessors;
            this.coverHttp = coverHttp;
            this.request = request;
            this.noSerialPreprocess = noSerialPreprocess;
        }

        @Override
        public CoverHttp<?> getTask() {
            return this.coverHttp;
        }

        @Override
        public Httpv getHttp() {
            return Httpv.this;
        }

        @Override
        public void proceed() {
            if (this.noSerialPreprocess) {
                while (this.index < this.preprocessors.length && this.preprocessors[this.index] instanceof SerialPreprocessor) {
                    ++this.index;
                }
            } else {
                Preprocessor last = this.preprocessors[this.index - 1];
                if (last instanceof SerialPreprocessor) {
                    ((SerialPreprocessor)last).afterProcess();
                }
            }
            if (this.index < this.preprocessors.length) {
                this.preprocessors[this.index++].doProcess(this);
            } else {
                this.request.run();
            }
        }
    }

    public static interface HttpvConfig {
        public void config(Httpd.Builder var1);
    }
}

