/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http;

import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.Http;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.UnoUrl;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.cache.CacheControl;

public class Request {
    final UnoUrl url;
    final String method;
    final Headers headers;
    final RequestBody body;
    final Map<Class<?>, Object> tags;
    private volatile CacheControl cacheControl;

    Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.tags = org.aoju.bus.http.Builder.immutableMap(builder.tags);
    }

    public UnoUrl url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Headers headers() {
        return this.headers;
    }

    public String header(String name) {
        return this.headers.get(name);
    }

    public List<String> headers(String name) {
        return this.headers.values(name);
    }

    public RequestBody body() {
        return this.body;
    }

    public Object tag() {
        return this.tag(Object.class);
    }

    public <T> T tag(Class<? extends T> type) {
        return type.cast(this.tags.get(type));
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public CacheControl cacheControl() {
        CacheControl result = this.cacheControl;
        return null != result ? result : (this.cacheControl = CacheControl.parse(this.headers));
    }

    public boolean isHttps() {
        return this.url.isHttps();
    }

    public String toString() {
        return "Request{method=" + this.method + ", url=" + this.url + ", tags=" + this.tags + "}";
    }

    public static class Builder {
        UnoUrl url;
        String method;
        Headers.Builder headers;
        RequestBody body;
        Map<Class<?>, Object> tags = Collections.emptyMap();

        public Builder() {
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        Builder(Request request) {
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            this.tags = request.tags.isEmpty() ? Collections.emptyMap() : new LinkedHashMap(request.tags);
            this.headers = request.headers.newBuilder();
        }

        public Builder url(UnoUrl url) {
            if (url == null) {
                throw new NullPointerException("url == null");
            }
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            if (url == null) {
                throw new NullPointerException("url == null");
            }
            if (((String)url).regionMatches(true, 0, "ws:", 0, 3)) {
                url = "http:" + ((String)url).substring(3);
            } else if (((String)url).regionMatches(true, 0, "wss:", 0, 4)) {
                url = "https:" + ((String)url).substring(4);
            }
            return this.url(UnoUrl.get((String)url));
        }

        public Builder url(URL url) {
            if (url == null) {
                throw new NullPointerException("url == null");
            }
            return this.url(UnoUrl.get(url.toString()));
        }

        public Builder header(String name, String value) {
            this.headers.set(name, value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.add(name, value);
            return this;
        }

        public Builder removeHeader(String name) {
            this.headers.removeAll(name);
            return this;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder cacheControl(CacheControl cacheControl) {
            String value = cacheControl.toString();
            if (value.isEmpty()) {
                return this.removeHeader("Cache-Control");
            }
            return this.header("Cache-Control", value);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder post(RequestBody body) {
            return this.method("POST", body);
        }

        public Builder delete(RequestBody body) {
            return this.method("DELETE", body);
        }

        public Builder delete() {
            return this.delete(RequestBody.create(null, Normal.EMPTY_BYTE_ARRAY));
        }

        public Builder put(RequestBody body) {
            return this.method("PUT", body);
        }

        public Builder patch(RequestBody body) {
            return this.method("PATCH", body);
        }

        public Builder method(String method, RequestBody body) {
            if (null == method) {
                throw new NullPointerException("method == null");
            }
            if (method.length() == 0) {
                throw new IllegalArgumentException("method.length() == 0");
            }
            if (body != null && !Http.permitsRequestBody(method)) {
                throw new IllegalArgumentException("method " + method + " must not have a request body.");
            }
            if (body == null && Http.requiresRequestBody(method)) {
                throw new IllegalArgumentException("method " + method + " must have a request body.");
            }
            this.method = method;
            this.body = body;
            return this;
        }

        public Builder tag(Object tag) {
            return this.tag(Object.class, tag);
        }

        public <T> Builder tag(Class<? super T> type, T tag) {
            if (null == type) {
                throw new NullPointerException("type == null");
            }
            if (null == tag) {
                this.tags.remove(type);
            } else {
                if (this.tags.isEmpty()) {
                    this.tags = new LinkedHashMap();
                }
                this.tags.put(type, type.cast(tag));
            }
            return this;
        }

        public Request build() {
            if (null == this.url) {
                throw new IllegalStateException("url == null");
            }
            return new Request(this);
        }
    }
}

