/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.accord.platform;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.aoju.bus.core.Version;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Protocol;
import org.aoju.bus.http.accord.platform.Platform;
import org.aoju.bus.http.secure.CertificateChainCleaner;
import org.aoju.bus.http.secure.TrustRootIndex;
import org.aoju.bus.logger.Logger;

class AndroidPlatform
extends Platform {
    private final Class<?> sslParametersClass;
    private final Class<?> sslSocketClass;
    private final Method setUseSessionTickets;
    private final Method setHostname;
    private final Method getAlpnSelectedProtocol;
    private final Method setAlpnProtocols;
    private final CloseGuard closeGuard = CloseGuard.get();

    AndroidPlatform(Class<?> sslParametersClass, Class<?> sslSocketClass, Method setUseSessionTickets, Method setHostname, Method getAlpnSelectedProtocol, Method setAlpnProtocols) {
        this.sslParametersClass = sslParametersClass;
        this.sslSocketClass = sslSocketClass;
        this.setUseSessionTickets = setUseSessionTickets;
        this.setHostname = setHostname;
        this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
        this.setAlpnProtocols = setAlpnProtocols;
    }

    public static Platform buildIfSupported() {
        Class<?> sslSocketClass;
        Class<?> sslParametersClass;
        if (!Platform.isAndroid()) {
            return null;
        }
        try {
            sslParametersClass = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            sslSocketClass = Class.forName("com.android.org.conscrypt.OpenSSLSocketImpl");
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
        try {
            Method setUseSessionTickets = sslSocketClass.getDeclaredMethod("setUseSessionTickets", Boolean.TYPE);
            Method setHostname = sslSocketClass.getMethod("setHostname", String.class);
            Method getAlpnSelectedProtocol = sslSocketClass.getMethod("getAlpnSelectedProtocol", new Class[0]);
            Method setAlpnProtocols = sslSocketClass.getMethod("setAlpnProtocols", byte[].class);
            return new AndroidPlatform(sslParametersClass, sslSocketClass, setUseSessionTickets, setHostname, getAlpnSelectedProtocol, setAlpnProtocols);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("Expected Android API level 21+ but was " + Version.all());
        }
    }

    @Override
    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        try {
            socket.connect(address, connectTimeout);
        }
        catch (AssertionError e) {
            if (Builder.isAndroidGetsocknameError(e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
        catch (ClassCastException e) {
            throw e;
        }
    }

    @Override
    protected X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        X509TrustManager x509TrustManager;
        Object context = AndroidPlatform.readFieldOrNull(sslSocketFactory, this.sslParametersClass, "sslParameters");
        if (context == null) {
            try {
                Class<?> gmsSslParametersClass = Class.forName("com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sslSocketFactory.getClass().getClassLoader());
                context = AndroidPlatform.readFieldOrNull(sslSocketFactory, gmsSslParametersClass, "sslParameters");
            }
            catch (ClassNotFoundException e) {
                return super.trustManager(sslSocketFactory);
            }
        }
        if ((x509TrustManager = AndroidPlatform.readFieldOrNull(context, X509TrustManager.class, "x509TrustManager")) != null) {
            return x509TrustManager;
        }
        return AndroidPlatform.readFieldOrNull(context, X509TrustManager.class, "trustManager");
    }

    @Override
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
        if (!this.sslSocketClass.isInstance(sslSocket)) {
            return;
        }
        try {
            if (hostname != null) {
                this.setUseSessionTickets.invoke((Object)sslSocket, true);
                this.setHostname.invoke((Object)sslSocket, hostname);
            }
            this.setAlpnProtocols.invoke((Object)sslSocket, new Object[]{AndroidPlatform.concatLengthPrefixed(protocols)});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket socket) {
        if (!this.sslSocketClass.isInstance(socket)) {
            return null;
        }
        try {
            byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invoke((Object)socket, new Object[0]);
            return alpnResult != null ? new String(alpnResult, Charset.UTF_8) : null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public Object getStackTraceForCloseable(String closer) {
        return this.closeGuard.createAndOpen(closer);
    }

    @Override
    public void logCloseableLeak(String message, Object stackTrace) {
        boolean reported = this.closeGuard.warnIfOpen(stackTrace);
        if (!reported) {
            Logger.warn(message, null);
        }
    }

    @Override
    public boolean isCleartextTrafficPermitted(String hostname) {
        try {
            Class<?> networkPolicyClass = Class.forName("android.security.NetworkSecurityPolicy");
            Method getInstanceMethod = networkPolicyClass.getMethod("getInstance", new Class[0]);
            Object networkSecurityPolicy = getInstanceMethod.invoke(null, new Object[0]);
            return this.api24IsCleartextTrafficPermitted(hostname, networkPolicyClass, networkSecurityPolicy);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return super.isCleartextTrafficPermitted(hostname);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new AssertionError("unable to determine cleartext support", e);
        }
    }

    private boolean api24IsCleartextTrafficPermitted(String hostname, Class<?> networkPolicyClass, Object networkSecurityPolicy) throws InvocationTargetException, IllegalAccessException {
        try {
            Method isCleartextTrafficPermittedMethod = networkPolicyClass.getMethod("isCleartextTrafficPermitted", String.class);
            return (Boolean)isCleartextTrafficPermittedMethod.invoke(networkSecurityPolicy, hostname);
        }
        catch (NoSuchMethodException e) {
            return this.api23IsCleartextTrafficPermitted(hostname, networkPolicyClass, networkSecurityPolicy);
        }
    }

    private boolean api23IsCleartextTrafficPermitted(String hostname, Class<?> networkPolicyClass, Object networkSecurityPolicy) throws InvocationTargetException, IllegalAccessException {
        try {
            Method isCleartextTrafficPermittedMethod = networkPolicyClass.getMethod("isCleartextTrafficPermitted", new Class[0]);
            return (Boolean)isCleartextTrafficPermittedMethod.invoke(networkSecurityPolicy, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return super.isCleartextTrafficPermitted(hostname);
        }
    }

    @Override
    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager trustManager) {
        try {
            Class<?> extensionsClass = Class.forName("android.net.http.X509TrustManagerExtensions");
            Constructor<?> constructor = extensionsClass.getConstructor(X509TrustManager.class);
            Object extensions = constructor.newInstance(trustManager);
            Method checkServerTrusted = extensionsClass.getMethod("checkServerTrusted", X509Certificate[].class, String.class, String.class);
            return new AndroidCertificateChainCleaner(extensions, checkServerTrusted);
        }
        catch (Exception e) {
            return super.buildCertificateChainCleaner(trustManager);
        }
    }

    @Override
    public TrustRootIndex buildTrustRootIndex(X509TrustManager trustManager) {
        try {
            Method method = trustManager.getClass().getDeclaredMethod("findTrustAnchorByIssuerAndSignature", X509Certificate.class);
            method.setAccessible(true);
            return new CustomTrustRootIndex(trustManager, method);
        }
        catch (NoSuchMethodException e) {
            return super.buildTrustRootIndex(trustManager);
        }
    }

    @Override
    public SSLContext getSSLContext() {
        try {
            return SSLContext.getInstance("TLSv1.2");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                return SSLContext.getInstance("TLS");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("No TLS provider", e);
            }
        }
    }

    static class CloseGuard {
        private final Method getMethod;
        private final Method openMethod;
        private final Method warnIfOpenMethod;

        CloseGuard(Method getMethod, Method openMethod, Method warnIfOpenMethod) {
            this.getMethod = getMethod;
            this.openMethod = openMethod;
            this.warnIfOpenMethod = warnIfOpenMethod;
        }

        static CloseGuard get() {
            Method warnIfOpenMethod;
            Method openMethod;
            Method getMethod;
            try {
                Class<?> closeGuardClass = Class.forName("dalvik.system.CloseGuard");
                getMethod = closeGuardClass.getMethod("get", new Class[0]);
                openMethod = closeGuardClass.getMethod("open", String.class);
                warnIfOpenMethod = closeGuardClass.getMethod("warnIfOpen", new Class[0]);
            }
            catch (Exception ignored) {
                getMethod = null;
                openMethod = null;
                warnIfOpenMethod = null;
            }
            return new CloseGuard(getMethod, openMethod, warnIfOpenMethod);
        }

        Object createAndOpen(String closer) {
            if (null != this.getMethod) {
                try {
                    Object closeGuardInstance = this.getMethod.invoke(null, new Object[0]);
                    this.openMethod.invoke(closeGuardInstance, closer);
                    return closeGuardInstance;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        boolean warnIfOpen(Object closeGuardInstance) {
            boolean reported = false;
            if (null != closeGuardInstance) {
                try {
                    this.warnIfOpenMethod.invoke(closeGuardInstance, new Object[0]);
                    reported = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return reported;
        }
    }

    static class AndroidCertificateChainCleaner
    extends CertificateChainCleaner {
        private final Object x509TrustManagerExtensions;
        private final Method checkServerTrusted;

        AndroidCertificateChainCleaner(Object x509TrustManagerExtensions, Method checkServerTrusted) {
            this.x509TrustManagerExtensions = x509TrustManagerExtensions;
            this.checkServerTrusted = checkServerTrusted;
        }

        @Override
        public List<Certificate> clean(List<Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
            try {
                X509Certificate[] certificates = chain.toArray(new X509Certificate[chain.size()]);
                return (List)this.checkServerTrusted.invoke(this.x509TrustManagerExtensions, new Object[]{certificates, Algorithm.RSA, hostname});
            }
            catch (InvocationTargetException e) {
                SSLPeerUnverifiedException exception = new SSLPeerUnverifiedException(e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }

        public boolean equals(Object other) {
            return other instanceof AndroidCertificateChainCleaner;
        }

        public int hashCode() {
            return 0;
        }
    }

    static class CustomTrustRootIndex
    implements TrustRootIndex {
        private final X509TrustManager trustManager;
        private final Method findByIssuerAndSignatureMethod;

        CustomTrustRootIndex(X509TrustManager trustManager, Method findByIssuerAndSignatureMethod) {
            this.findByIssuerAndSignatureMethod = findByIssuerAndSignatureMethod;
            this.trustManager = trustManager;
        }

        @Override
        public X509Certificate findByIssuerAndSignature(X509Certificate cert) {
            try {
                TrustAnchor trustAnchor = (TrustAnchor)this.findByIssuerAndSignatureMethod.invoke((Object)this.trustManager, cert);
                return trustAnchor != null ? trustAnchor.getTrustedCert() : null;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError("unable to get issues and signature", e);
            }
            catch (InvocationTargetException e) {
                return null;
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof CustomTrustRootIndex)) {
                return false;
            }
            CustomTrustRootIndex that = (CustomTrustRootIndex)object;
            return this.trustManager.equals(that.trustManager) && this.findByIssuerAndSignatureMethod.equals(that.findByIssuerAndSignatureMethod);
        }

        public int hashCode() {
            return this.trustManager.hashCode() + 31 * this.findByIssuerAndSignatureMethod.hashCode();
        }
    }
}

