/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpv;

public class Progress {
    public static final int DEFAULT_STEP_BYTES = 8192;
    private long totalBytes;
    private long doneBytes;

    public Progress(long totalBytes, long doneBytes) {
        this.totalBytes = totalBytes;
        this.doneBytes = doneBytes;
    }

    public double getRate() {
        return (double)this.doneBytes / (double)this.totalBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getDoneBytes() {
        return this.doneBytes;
    }

    public boolean isDone() {
        return this.doneBytes >= this.totalBytes;
    }

    public void addDoneBytes(long delt) {
        this.doneBytes += delt;
    }

    public void increaseDoneBytes() {
        ++this.doneBytes;
    }

    public boolean notDoneOrReached(long bytes) {
        return this.doneBytes < bytes && this.doneBytes < this.totalBytes;
    }
}

