/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpz;

import java.io.IOException;
import org.aoju.bus.core.io.buffer.Buffer;
import org.aoju.bus.core.io.source.AssignSource;
import org.aoju.bus.core.io.source.BufferSource;
import org.aoju.bus.core.io.source.Source;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.bodys.ResponseBody;
import org.aoju.bus.http.metric.Interceptor;
import org.aoju.bus.http.plugin.httpz.ProgressListener;

public abstract class FileInterceptor
implements Interceptor,
ProgressListener {
    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response rsp = chain.proceed(chain.request());
        return rsp.newBuilder().body(new DownloadFileProgressResponseBody(rsp.body(), this)).build();
    }

    @Override
    public abstract void updateProgress(long var1, long var3, boolean var5);

    public static class DownloadFileProgressResponseBody
    extends ResponseBody {
        private final ResponseBody body;
        private final ProgressListener progressListener;
        private BufferSource bufferedSource;

        public DownloadFileProgressResponseBody(ResponseBody body, ProgressListener progressListener) {
            this.body = body;
            this.progressListener = progressListener;
        }

        @Override
        public MediaType contentType() {
            return this.body.contentType();
        }

        @Override
        public long contentLength() {
            return this.body.contentLength();
        }

        @Override
        public BufferSource source() {
            if (null == this.bufferedSource) {
                this.bufferedSource = IoKit.buffer(this.source(this.body.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new AssignSource(source){
                long downloadLenth;
                {
                    super(delegate);
                    this.downloadLenth = 0L;
                }

                @Override
                public long read(Buffer sink, long byteCount) throws IOException {
                    boolean isFinish;
                    long bytesRead = super.read(sink, byteCount);
                    boolean bl = isFinish = bytesRead == -1L;
                    if (!isFinish) {
                        this.downloadLenth += bytesRead;
                    }
                    progressListener.updateProgress(this.downloadLenth, body.contentLength(), isFinish);
                    return bytesRead;
                }
            };
        }
    }
}

