/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.plugin.httpz;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.http.Httpd;
import org.aoju.bus.http.bodys.MultipartBody;
import org.aoju.bus.http.plugin.httpz.PostRequest;
import org.aoju.bus.http.plugin.httpz.RequestBuilder;
import org.aoju.bus.http.plugin.httpz.RequestCall;

public class PostBuilder
extends RequestBuilder<PostBuilder> {
    private List<PostRequest.FileInfo> fileInfos = new ArrayList<PostRequest.FileInfo>();
    private String postBody;
    private MultipartBody multipartBody;

    public PostBuilder(Httpd httpd) {
        super(httpd);
    }

    @Override
    public RequestCall build() {
        return new PostRequest(this.url, this.tag, this.params, this.encodedParams, this.headers, this.fileInfos, this.postBody, this.multipartBody, this.id).build(this.httpd);
    }

    public PostBuilder body(String postBody) {
        this.postBody = postBody;
        return this;
    }

    public PostBuilder multipartBody(MultipartBody multipartBody) {
        this.multipartBody = multipartBody;
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, byte[] content) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.fileContent = content;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, InputStream is) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.fileInputStream = is;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, File file) {
        PostRequest.FileInfo fileInfo = new PostRequest.FileInfo();
        fileInfo.partName = partName;
        fileInfo.fileName = fileName;
        fileInfo.file = file;
        this.fileInfos.add(fileInfo);
        return this;
    }

    public PostBuilder addFile(String partName, String fileName, String content) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content, "UTF-8");
    }

    public PostBuilder addFile(String partName, String fileName, String content, String charsetName) throws UnsupportedEncodingException {
        return this.addFile(partName, fileName, content.getBytes(charsetName));
    }

    public PostBuilder addFile(String partName, String fileName, byte[] content, String charsetName) {
        return this.addFile(partName, fileName, content);
    }
}

