/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.secure;

import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.aoju.bus.http.Builder;

public class HostnameVerifier
implements javax.net.ssl.HostnameVerifier {
    public static final HostnameVerifier INSTANCE = new HostnameVerifier();
    private static final int ALT_DNS_NAME = 2;
    private static final int ALT_IPA_NAME = 7;

    private HostnameVerifier() {
    }

    public static List<String> allSubjectAltNames(X509Certificate certificate) {
        List<String> altIpaNames = HostnameVerifier.getSubjectAltNames(certificate, 7);
        List<String> altDnsNames = HostnameVerifier.getSubjectAltNames(certificate, 2);
        ArrayList<String> result = new ArrayList<String>(altIpaNames.size() + altDnsNames.size());
        result.addAll(altIpaNames);
        result.addAll(altDnsNames);
        return result;
    }

    private static List<String> getSubjectAltNames(X509Certificate certificate, int type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (null == subjectAltNames) {
                return Collections.emptyList();
            }
            for (List<?> subjectAltName : subjectAltNames) {
                String altName;
                Integer altNameType;
                List<?> entry = subjectAltName;
                if (null == entry || entry.size() < 2 || null == (altNameType = (Integer)entry.get(0)) || altNameType != type || null == (altName = (String)entry.get(1))) continue;
                result.add(altName);
            }
            return result;
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public boolean verify(String host, SSLSession session) {
        try {
            Certificate[] certificates = session.getPeerCertificates();
            return this.verify(host, (X509Certificate)certificates[0]);
        }
        catch (SSLException e) {
            return false;
        }
    }

    public boolean verify(String host, X509Certificate certificate) {
        return Builder.verifyAsIpAddress(host) ? this.verifyIpAddress(host, certificate) : this.verifyHostname(host, certificate);
    }

    private boolean verifyIpAddress(String ipAddress, X509Certificate certificate) {
        List<String> altNames = HostnameVerifier.getSubjectAltNames(certificate, 7);
        int size = altNames.size();
        for (int i = 0; i < size; ++i) {
            if (!ipAddress.equalsIgnoreCase(altNames.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean verifyHostname(String hostname, X509Certificate certificate) {
        hostname = hostname.toLowerCase(Locale.US);
        List<String> altNames = HostnameVerifier.getSubjectAltNames(certificate, 2);
        for (String altName : altNames) {
            if (!this.verifyHostname(hostname, altName)) continue;
            return true;
        }
        return false;
    }

    public boolean verifyHostname(String hostname, String pattern) {
        if (null == hostname || ((String)hostname).length() == 0 || ((String)hostname).startsWith(".") || ((String)hostname).endsWith("..")) {
            return false;
        }
        if (null == pattern || ((String)pattern).length() == 0 || ((String)pattern).startsWith(".") || ((String)pattern).endsWith("..")) {
            return false;
        }
        if (!((String)hostname).endsWith(".")) {
            hostname = (String)hostname + ".";
        }
        if (!((String)pattern).endsWith(".")) {
            pattern = (String)pattern + ".";
        }
        if (!((String)(pattern = ((String)pattern).toLowerCase(Locale.US))).contains("*")) {
            return ((String)hostname).equals(pattern);
        }
        if (!((String)pattern).startsWith("*.") || ((String)pattern).indexOf(42, 1) != -1) {
            return false;
        }
        if (((String)hostname).length() < ((String)pattern).length()) {
            return false;
        }
        if ("*.".equals(pattern)) {
            return false;
        }
        String suffix = ((String)pattern).substring(1);
        if (!((String)hostname).endsWith(suffix)) {
            return false;
        }
        int suffixStartIndexInHostname = ((String)hostname).length() - suffix.length();
        return suffixStartIndexInHostname <= 0 || ((String)hostname).lastIndexOf(46, suffixStartIndexInHostname - 1) == -1;
    }
}

