/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.aoju.bus.image.galaxy.data.Attributes;
import org.aoju.bus.image.nimble.LookupTableFactory;

public class PaletteColorModel
extends ColorModel {
    private static final int[] opaqueBits = new int[]{8, 8, 8};
    private final LUT lut;

    public PaletteColorModel(int bits, int dataType, ColorSpace cs, Attributes ds) {
        super(bits, opaqueBits, cs, false, false, 1, dataType);
        int[] rDesc = this.lutDescriptor(ds, 2625793);
        int[] gDesc = this.lutDescriptor(ds, 2625794);
        int[] bDesc = this.lutDescriptor(ds, 2625795);
        byte[] r = this.lutData(ds, rDesc, 2626049, 0x281221);
        byte[] g = this.lutData(ds, gDesc, 2626050, 0x281222);
        byte[] b = this.lutData(ds, bDesc, 2626051, 2626083);
        this.lut = LUT.create(bits, r, g, b, rDesc[1], gDesc[1], bDesc[1]);
    }

    private static void endOfSegmentedLut() {
        throw new IllegalArgumentException("Running out of data inflating segmented LUT");
    }

    private static int linearSegment(int y1, byte[] out, int x, int n) {
        if (x == 0) {
            throw new IllegalArgumentException("Linear segment cannot be the first segment");
        }
        try {
            byte y0 = out[x - 1];
            int dy = y1 - y0;
            for (int j = 1; j <= n; ++j) {
                out[x++] = (byte)(y0 + dy * j / n >> 8);
            }
        }
        catch (IndexOutOfBoundsException e) {
            PaletteColorModel.exceedsLutLength(out.length);
        }
        return x;
    }

    private static void exceedsLutLength(int descLen) {
        throw new IllegalArgumentException("Number of entries in inflated segmented LUT exceeds specified value: " + descLen + " in LUT Descriptor");
    }

    private static void lutLengthMismatch(int lutLen, int descLen) {
        throw new IllegalArgumentException("Number of actual LUT entries: " + lutLen + " mismatch specified value: " + descLen + " in LUT Descriptor");
    }

    private static void illegalOpcode(int op, int i) {
        throw new IllegalArgumentException("illegal op internal:" + op + ", index:" + i);
    }

    private int[] lutDescriptor(Attributes ds, int descTag) {
        int[] desc = ds.getInts(descTag);
        if (null == desc) {
            throw new IllegalArgumentException("Missing LUT Descriptor!");
        }
        if (desc.length != 3) {
            throw new IllegalArgumentException("Illegal number of LUT Descriptor values: " + desc.length);
        }
        if (desc[0] < 0) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: len=" + desc[0]);
        }
        int bits = desc[2];
        if (bits != 8 && bits != 16) {
            throw new IllegalArgumentException("Illegal LUT Descriptor: bits=" + bits);
        }
        return desc;
    }

    private byte[] lutData(Attributes ds, int[] desc, int dataTag, int segmTag) {
        int len = desc[0] == 0 ? 65536 : desc[0];
        int bits = desc[2];
        byte[] data = ds.getSafeBytes(dataTag);
        if (null == data) {
            int[] segm = ds.getInts(segmTag);
            if (null == segm) {
                throw new IllegalArgumentException("Missing LUT Data!");
            }
            if (bits == 8) {
                throw new IllegalArgumentException("Segmented LUT Data with LUT Descriptor: bits=8");
            }
            data = new byte[len];
            this.inflateSegmentedLut(segm, data);
        } else if (bits == 16 || data.length != len) {
            int hilo;
            if (data.length != len << 1) {
                PaletteColorModel.lutLengthMismatch(data.length, len);
            }
            int n = hilo = ds.bigEndian() ? 0 : 1;
            if (bits == 8) {
                hilo = 1 - hilo;
            }
            data = LookupTableFactory.halfLength(data, hilo);
        }
        return data;
    }

    private void inflateSegmentedLut(int[] in, byte[] out) {
        int x = 0;
        try {
            int i = 0;
            block11: while (i < in.length) {
                int op = in[i++];
                int n = in[i++];
                switch (op) {
                    case 0: {
                        while (n-- > 0) {
                            out[x++] = (byte)in[i++];
                        }
                        continue block11;
                    }
                    case 1: {
                        x = PaletteColorModel.linearSegment(in[i++], out, x, n);
                        continue block11;
                    }
                    case 2: {
                        int i2 = in[i++] & 0xFFFF | in[i++] << 16;
                        block13: while (n-- > 0) {
                            int op2 = in[i2++];
                            int n2 = in[i2++] & 0xFFFF;
                            switch (op2) {
                                case 0: {
                                    while (n2-- > 0) {
                                        out[x++] = (byte)in[i2++];
                                    }
                                    continue block13;
                                }
                                case 1: {
                                    x = PaletteColorModel.linearSegment(in[i2++], out, x, n);
                                    continue block13;
                                }
                            }
                            PaletteColorModel.illegalOpcode(op, i2 - 2);
                        }
                        break;
                    }
                }
                PaletteColorModel.illegalOpcode(op, i - 2);
            }
        }
        catch (IndexOutOfBoundsException e) {
            if (x > out.length) {
                PaletteColorModel.exceedsLutLength(out.length);
            }
            PaletteColorModel.endOfSegmentedLut();
        }
        if (x < out.length) {
            PaletteColorModel.lutLengthMismatch(x, out.length);
        }
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        return this.isCompatibleSampleModel(raster.getSampleModel());
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        return sm.getTransferType() == this.transferType && sm.getNumBands() == 1;
    }

    @Override
    public int getRed(int pixel) {
        return this.lut.getRed(pixel);
    }

    @Override
    public int getGreen(int pixel) {
        return this.lut.getGreen(pixel);
    }

    @Override
    public int getBlue(int pixel) {
        return this.lut.getBlue(pixel);
    }

    @Override
    public int getAlpha(int pixel) {
        return this.lut.getAlpha(pixel);
    }

    @Override
    public int getRGB(int pixel) {
        return this.lut.getRGB(pixel);
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        return Raster.createInterleavedRaster(this.pixel_bits <= 8 ? 0 : 1, w, h, 1, null);
    }

    public BufferedImage convertToIntDiscrete(Raster raster) {
        if (!this.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException("This raster is not compatible with this PaletteColorModel.");
        }
        DirectColorModel cm = new DirectColorModel(this.getColorSpace(), 24, 0xFF0000, 65280, 255, 0, false, 3);
        int w = raster.getWidth();
        int h = raster.getHeight();
        WritableRaster discreteRaster = ((ColorModel)cm).createCompatibleWritableRaster(w, h);
        int[] discretData = ((DataBufferInt)discreteRaster.getDataBuffer()).getData();
        DataBuffer data = raster.getDataBuffer();
        if (data instanceof DataBufferByte) {
            byte[] pixels = ((DataBufferByte)data).getData();
            for (int i = 0; i < pixels.length; ++i) {
                discretData[i] = this.getRGB(pixels[i]);
            }
        } else {
            short[] pixels = ((DataBufferUShort)data).getData();
            for (int i = 0; i < pixels.length; ++i) {
                discretData[i] = this.getRGB(pixels[i]);
            }
        }
        return new BufferedImage(cm, discreteRaster, false, null);
    }

    private static abstract class LUT {
        final int mask;

        LUT(int bits) {
            this.mask = (1 << bits) - 1;
        }

        public static LUT create(int bits, byte[] r, byte[] g, byte[] b, int rOffset, int gOffset, int bOffset) {
            return r.length == g.length && g.length == b.length && rOffset == gOffset && gOffset == bOffset ? new Packed(bits, r, g, b, rOffset) : new PerColor(bits, r, g, b, rOffset, gOffset, bOffset);
        }

        int index(int pixel, int offset, int length) {
            return Math.min(Math.max(0, (pixel & this.mask) - offset), length - 1);
        }

        abstract int getRed(int var1);

        abstract int getGreen(int var1);

        abstract int getBlue(int var1);

        abstract int getAlpha(int var1);

        abstract int getRGB(int var1);

        static class Packed
        extends LUT {
            final int offset;
            final int[] rgb;

            Packed(int bits, byte[] r, byte[] g, byte[] b, int offset) {
                super(bits);
                int length = r.length;
                this.offset = offset;
                this.rgb = new int[length];
                for (int i = 0; i < r.length; ++i) {
                    this.rgb[i] = 0xFF000000 | (r[i] & 0xFF) << 16 | (g[i] & 0xFF) << 8 | b[i] & 0xFF;
                }
            }

            @Override
            public int getAlpha(int pixel) {
                return this.rgb[this.index(pixel, this.offset, this.rgb.length)] >> 24 & 0xFF;
            }

            @Override
            public int getRed(int pixel) {
                return this.rgb[this.index(pixel, this.offset, this.rgb.length)] >> 16 & 0xFF;
            }

            @Override
            public int getGreen(int pixel) {
                return this.rgb[this.index(pixel, this.offset, this.rgb.length)] >> 8 & 0xFF;
            }

            @Override
            public int getBlue(int pixel) {
                return this.rgb[this.index(pixel, this.offset, this.rgb.length)] & 0xFF;
            }

            @Override
            public int getRGB(int pixel) {
                return this.rgb[this.index(pixel, this.offset, this.rgb.length)];
            }
        }

        static class PerColor
        extends LUT {
            final byte[] r;
            final byte[] g;
            final byte[] b;
            final int rOffset;
            final int gOffset;
            final int bOffset;

            PerColor(int bits, byte[] r, byte[] g, byte[] b, int rOffset, int gbOffset, int bOffset) {
                super(bits);
                this.r = r;
                this.g = g;
                this.b = b;
                this.rOffset = rOffset;
                this.gOffset = gbOffset;
                this.bOffset = bOffset;
            }

            @Override
            public int getAlpha(int pixel) {
                return 255;
            }

            @Override
            public int getRed(int pixel) {
                return this.value(pixel, this.rOffset, this.r);
            }

            @Override
            public int getGreen(int pixel) {
                return this.value(pixel, this.gOffset, this.g);
            }

            @Override
            public int getBlue(int pixel) {
                return this.value(pixel, this.bOffset, this.b);
            }

            @Override
            public int getRGB(int pixel) {
                return 0xFF000000 | this.value(pixel, this.rOffset, this.r) << 16 | this.value(pixel, this.gOffset, this.g) << 8 | this.value(pixel, this.bOffset, this.b);
            }

            int value(int pixel, int offset, byte[] lut) {
                return lut[this.index(pixel, offset, lut.length)] & 0xFF;
            }
        }
    }
}

