/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.limiter.support.rate.redis;

import java.util.Arrays;
import java.util.Objects;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedisRatelimiterObject
extends RedissonObject {
    public RedisRatelimiterObject(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    public RedisRatelimiterObject(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public boolean tryAcquire(long permits, double rate, long capacity) {
        if (permits > capacity) {
            return false;
        }
        return (Long)this.get(this.tryAcquireAsync((RedisCommand)RedisCommands.EVAL_LONG, permits, rate, capacity)) != -1L;
    }

    private <T> RFuture<T> tryAcquireAsync(RedisCommand<T> command, long permits, double rate, long capacity) {
        String hash = "" + Objects.hash(rate, capacity);
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, command, "local capacity = tonumber(ARGV[1])\nlocal rate = tonumber(ARGV[2])\nlocal acq = tonumber(ARGV[3])\nif (redis.call('exists',KEYS[1]) == 0 or redis.call('hget',KEYS[1],'hash') ~= ARGV[4]) then\n    -- create\n    redis.call('hset', KEYS[1], 'capacity ', capacity)\n    redis.call('hset', KEYS[1], 'rate', rate)\n    redis.call('hset', KEYS[1], 'permit', capacity-acq)\n    redis.call('hset', KEYS[1], 'hash', ARGV[4])\n    redis.call('expire', KEYS[1],3153600000000)\n    redis.call('hset', KEYS[1], 'pttl',3153600000000000)\n    return capacity-acq\nend\nlocal rate = tonumber(redis.call('hget', KEYS[1],'rate'))\nlocal now = redis.call('pttl', KEYS[1])\nlocal pttl = tonumber(redis.call('hget', KEYS[1], 'pttl'))\nlocal permit = tonumber(redis.call('hget', KEYS[1], 'permit'))\nlocal newPermit = permit + ((pttl-now)/1000*rate)\nif(newPermit >= capacity) then\n     redis.call('hset', KEYS[1], 'permit', capacity-acq)\n     redis.call('hset', KEYS[1], 'pttl', now)\n     return capacity-acq\nend\nif(newPermit >= acq) then\n    redis.call('hset', KEYS[1], 'permit', newPermit-acq)\n    redis.call('hset', KEYS[1], 'pttl', now)\n    return newPermit-acq\nend\nreturn -1 ", Arrays.asList(this.getName()), new Object[]{permits, rate, capacity, hash});
    }
}

