/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.provider.base;

import java.util.Set;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.mapper.builder.EntityBuilder;
import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.SelectKeyBuilder;
import org.aoju.bus.mapper.builder.SqlBuilder;
import org.aoju.bus.mapper.entity.EntityColumn;
import org.apache.ibatis.mapping.MappedStatement;

public class BaseInsertProvider
extends MapperTemplate {
    public BaseInsertProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public String insert(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        EntityColumn logicDeleteColumn = SqlBuilder.getLogicDeleteColumn(entityClass);
        this.processKey(sql, entityClass, ms, columnList);
        sql.append(SqlBuilder.insertIntoTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.insertColumns(entityClass, false, false, false));
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(SqlBuilder.getLogicDeletedValue(column, false)).append(",");
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlBuilder.getIfCacheNotNull(column, column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlBuilder.getIfNotNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
            }
            if (column.isIdentity()) {
                sql.append(SqlBuilder.getIfCacheIsNull(column, column.getColumnHolder() + ","));
                continue;
            }
            sql.append(SqlBuilder.getIfIsNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    public String insertSelective(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        Set<EntityColumn> columnList = EntityBuilder.getColumns(entityClass);
        EntityColumn logicDeleteColumn = SqlBuilder.getLogicDeleteColumn(entityClass);
        this.processKey(sql, entityClass, ms, columnList);
        sql.append(SqlBuilder.insertIntoTable(entityClass, this.tableName(entityClass)));
        sql.append("<trim prefix=\"(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (column.isIdentity()) {
                sql.append(column.getColumn()).append(",");
                continue;
            }
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(column.getColumn()).append(",");
                continue;
            }
            sql.append(SqlBuilder.getIfNotNull(column, column.getColumn() + ",", this.isNotEmpty()));
        }
        sql.append("</trim>");
        sql.append("<trim prefix=\"VALUES(\" suffix=\")\" suffixOverrides=\",\">");
        for (EntityColumn column : columnList) {
            if (!column.isInsertable()) continue;
            if (logicDeleteColumn != null && logicDeleteColumn == column) {
                sql.append(SqlBuilder.getLogicDeletedValue(column, false)).append(",");
                continue;
            }
            if (column.isIdentity()) {
                sql.append(SqlBuilder.getIfCacheNotNull(column, column.getColumnHolder(null, "_cache", ",")));
            } else {
                sql.append(SqlBuilder.getIfNotNull(column, column.getColumnHolder(null, null, ","), this.isNotEmpty()));
            }
            if (!column.isIdentity()) continue;
            sql.append(SqlBuilder.getIfCacheIsNull(column, column.getColumnHolder() + ","));
        }
        sql.append("</trim>");
        return sql.toString();
    }

    private void processKey(StringBuilder sql, Class<?> entityClass, MappedStatement ms, Set<EntityColumn> columnList) {
        Boolean hasIdentityKey = false;
        for (EntityColumn column : columnList) {
            if (column.isIdentity()) {
                sql.append(SqlBuilder.getBindCache(column));
                if (hasIdentityKey.booleanValue()) {
                    if (column.getGenerator() != null && "JDBC".equals(column.getGenerator())) continue;
                    throw new InstrumentException(ms.getId() + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u4e2d\u5305\u542b\u591a\u4e2aMySql\u7684\u81ea\u52a8\u589e\u957f\u5217,\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a!");
                }
                SelectKeyBuilder.newSelectKeyMappedStatement(ms, column, entityClass, this.isBEFORE(), this.getIDENTITY(column));
                hasIdentityKey = true;
                continue;
            }
            if (column.getGenIdClass() == null) continue;
            sql.append("<bind name=\"").append(column.getColumn()).append("GenIdBind\" value=\"@org.aoju.bus.mapper.genid.GenId@genId(");
            sql.append("_parameter").append(", '").append(column.getProperty()).append("'");
            sql.append(", @").append(column.getGenIdClass().getCanonicalName()).append("@class");
            sql.append(", '").append(this.tableName(entityClass)).append("'");
            sql.append(", '").append(column.getColumn()).append("')");
            sql.append("\"/>");
        }
    }
}

