/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.yunpian;

import java.util.HashMap;
import java.util.Objects;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.yunpian.YunpianProperty;

public class YunpianSmsProvider
extends AbstractProvider<YunpianProperty, Context> {
    public YunpianSmsProvider(Context context) {
        super(context);
    }

    @Override
    public Message send(YunpianProperty entity) {
        HashMap<String, Object> bodys = new HashMap<String, Object>();
        bodys.put("apikey", entity.getApikey());
        bodys.put("mobile", entity.getReceive());
        bodys.put("tpl_id", entity.getTemplate());
        bodys.put("tpl_value", entity.getParams());
        String response = Httpx.post(entity.getUrl(), bodys);
        boolean succeed = Objects.equals(JsonKit.getValue(response, "code"), 0);
        String errcode = succeed ? Builder.ErrorCode.SUCCESS.getCode() : Builder.ErrorCode.FAILURE.getCode();
        String errmsg = succeed ? Builder.ErrorCode.SUCCESS.getMsg() : Builder.ErrorCode.FAILURE.getMsg();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }
}

