/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.AuthorizedException;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class TaobaoProvider
extends AbstractProvider {
    public TaobaoProvider(Context context) {
        super(context, Registry.TAOBAO);
    }

    public TaobaoProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.TAOBAO, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        return AccToken.builder().accessCode(callback.getCode()).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String response = this.doPostAuthorizationCode(accToken.getAccessCode());
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
        accToken.setAccessToken(object.getString("access_token"));
        accToken.setRefreshToken(object.getString("refresh_token"));
        accToken.setExpireIn(object.getIntValue("expires_in"));
        accToken.setUid(object.getString("taobao_user_id"));
        accToken.setOpenId(object.getString("taobao_open_uid"));
        accToken = this.getAuthToken(object);
        String nick = UriKit.decode(object.getString("taobao_user_nick"));
        return Property.builder().rawJson(new JSONObject()).uuid(StringKit.isEmpty(accToken.getUid()) ? accToken.getOpenId() : accToken.getUid()).username(nick).nickname(nick).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.context.getAppKey()).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("view", "web").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public Message refresh(AccToken oldToken) {
        String response = Httpx.post(this.refreshTokenUrl(oldToken.getRefreshToken()));
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        return Message.builder().errcode(Builder.ErrorCode.SUCCESS.getCode()).data(this.getAuthToken(accessTokenObject)).build();
    }

    private AccToken getAuthToken(JSONObject object) {
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).tokenType(object.getString("token_type")).idToken(object.getString("id_token")).refreshToken(object.getString("refresh_token")).uid(object.getString("taobao_user_id")).openId(object.getString("taobao_open_uid")).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getString("error_description"));
        }
    }
}

